/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Throwing;
import com.diffplug.common.tree.TreeStream;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.JavaExecWinFriendly;
import com.diffplug.gradle.JavaExecableImp;
import com.diffplug.gradle.ProjectPlugin;
import com.diffplug.gradle.SerializableMisc;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.gradle.testfixtures.ProjectBuilder;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;

public interface JavaExecable
extends Serializable,
Throwing.Runnable {
    public static final String BUILDSCRIPT_CLASSPATH = "classpath";

    public static <T extends JavaExecable> T exec(WorkQueue queue, T input) throws Throwable {
        File tempFile = File.createTempFile("JavaExecQueue", ".temp");
        queue.submit(PlugAction.class, action -> {
            action.getInput().set((Object)input);
            action.getOutputFile().set(tempFile);
        });
        queue.await();
        JavaExecable result = (JavaExecable)SerializableMisc.read(tempFile);
        FileMisc.forceDelete(tempFile);
        return (T)result;
    }

    public static <T extends JavaExecable> T exec(Project project, T input, Action<JavaExecSpec> settings) throws Throwable {
        List classpaths = TreeStream.toParent(ProjectPlugin.treeDef(), (Object)project).map(p -> p.getBuildscript().getConfigurations().getByName(BUILDSCRIPT_CLASSPATH)).collect(Collectors.toList());
        classpaths.add(project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().gradleApi()}));
        classpaths.add(project.files(new Object[]{JavaExecableImp.fromLocalClassloader()}));
        return JavaExecableImp.execInternal(input, (FileCollection)project.files(new Object[]{classpaths}), settings, (Throwing.Function<Action<JavaExecSpec>, ExecResult>)((Throwing.Function)execSpec -> JavaExecWinFriendly.javaExec(project, (Action<JavaExecSpec>)execSpec)));
    }

    public static <T extends JavaExecable> T exec(Project project, T input) throws Throwable {
        return JavaExecable.exec(project, input, (Action<JavaExecSpec>)((Action)unused -> {}));
    }

    public static <T extends JavaExecable> T execWithoutGradle(T input, Action<JavaExecSpec> settings) throws Throwable {
        Set<File> classpath = JavaExecableImp.fromLocalClassloader();
        Project project = ProjectBuilder.builder().build();
        return JavaExecableImp.execInternal(input, (FileCollection)project.files(new Object[]{classpath}), settings, (Throwing.Function<Action<JavaExecSpec>, ExecResult>)((Throwing.Function)execSpec -> JavaExecWinFriendly.javaExec(project, (Action<JavaExecSpec>)execSpec)));
    }

    public static <T extends JavaExecable> T execWithoutGradle(T input) throws Throwable {
        return JavaExecable.execWithoutGradle(input, (Action<JavaExecSpec>)((Action)unused -> {}));
    }

    public static void main(String[] args) throws IOException {
        File file = new File(args[0]);
        try {
            JavaExecable javaExecOutside = (JavaExecable)SerializableMisc.read(file);
            javaExecOutside.run();
            SerializableMisc.write(file, javaExecOutside);
        }
        catch (Throwable t) {
            SerializableMisc.writeThrowable(file, t);
        }
    }

    public static enum Mode {
        INTERNAL,
        EXTERNAL;

    }

    public static abstract class PlugAction
    implements WorkAction<PlugParameters> {
        public void execute() {
            JavaExecable gen = (JavaExecable)((PlugParameters)this.getParameters()).getInput().get();
            try {
                gen.run();
                SerializableMisc.write(((RegularFile)((PlugParameters)this.getParameters()).getOutputFile().get()).getAsFile(), gen);
            }
            catch (Throwable e) {
                throw Errors.asRuntime((Throwable)e);
            }
        }
    }

    public static interface PlugParameters
    extends WorkParameters {
        public Property<JavaExecable> getInput();

        public RegularFileProperty getOutputFile();
    }
}

