/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipserunner;

import com.diffplug.gradle.JRE;
import com.diffplug.gradle.eclipserunner.EclipseRunner;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JarFolderRunner
implements EclipseRunner {
    final File rootDirectory;

    public JarFolderRunner(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    @Override
    public void run(List<String> args) throws Exception {
        File plugins = new File(this.rootDirectory, "plugins");
        ArrayList<URL> osgiClasspath = new ArrayList<URL>();
        for (File plugin : plugins.listFiles()) {
            if (!plugin.isFile() || !plugin.getName().endsWith(".jar")) continue;
            osgiClasspath.add(plugin.toURI().toURL());
        }
        try (URLClassLoader classLoader = JarFolderRunner.open(osgiClasspath);){
            Class<?> launcherClazz = classLoader.loadClass("com.diffplug.gradle.eclipserunner.EquinoxLauncher");
            Object launcher = launcherClazz.getConstructor(File.class).newInstance(this.rootDirectory);
            launcherClazz.getDeclaredMethod("setArgs", List.class).invoke(launcher, args);
            launcherClazz.getDeclaredMethod("run", new Class[0]).invoke(launcher, new Object[0]);
        }
    }

    public static URLClassLoader open(List<URL> urls) throws Exception {
        URL[] boot;
        ClassLoader parent = null;
        if (JRE.majorVersion() >= 9) {
            ClassLoader appClassLoader = ClassLoader.getSystemClassLoader();
            parent = appClassLoader.getParent();
            boot = JRE.getClasspath(appClassLoader);
        } else {
            parent = ClassLoader.getSystemClassLoader();
            boot = JRE.getClasspath(parent);
        }
        ArrayList<URL> classpath = new ArrayList<URL>();
        classpath.addAll(urls);
        classpath.addAll(Arrays.asList(boot));
        return new URLClassLoader(classpath.toArray(new URL[0]), parent);
    }
}

