/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.StandardSystemProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Optional;
import org.gradle.api.Project;

@SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
public class GoomphCacheLocations {
    private static final String ROOT = ".goomph";
    public static File override_eclipseReleaseMetadata = null;
    public static File override_workspaces = null;
    public static String override_p2bootstrapUrl = null;
    public static File override_p2bootstrap = null;
    public static String override_pdeBootstrapUrl = null;
    public static File override_pdeBootstrap = null;
    public static File override_bundlePool = null;

    public static void initFromProject(Project project) {
        for (Field field : GoomphCacheLocations.class.getFields()) {
            Object value = project.getProperties().get("goomph_" + field.getName());
            if (value == null) continue;
            Errors.rethrow().run(() -> field.set(null, value));
        }
    }

    public static File eclipseReleaseMetadata() {
        return GoomphCacheLocations.defOverride(".goomph/eclipse-release-metadata", override_eclipseReleaseMetadata);
    }

    public static File workspaces() {
        return GoomphCacheLocations.defOverride(".goomph/ide-workspaces", override_workspaces);
    }

    public static Optional<String> p2bootstrapUrl() {
        return Optional.ofNullable(override_p2bootstrapUrl);
    }

    public static File p2bootstrap() {
        return GoomphCacheLocations.defOverride(".goomph/p2-bootstrap", override_p2bootstrap);
    }

    public static Optional<String> pdeBootstrapUrl() {
        return Optional.ofNullable(override_pdeBootstrapUrl);
    }

    public static File pdeBootstrap() {
        return GoomphCacheLocations.defOverride(".goomph/pde-bootstrap", override_pdeBootstrap);
    }

    public static File bundlePool() {
        return GoomphCacheLocations.defOverride(".goomph/shared-bundles", override_bundlePool);
    }

    private static File defOverride(String userHomeRelative, File override) {
        return Optional.ofNullable(override).orElseGet(() -> GoomphCacheLocations.userHome().resolve(userHomeRelative).toFile());
    }

    private static Path userHome() {
        return new File(StandardSystemProperty.USER_HOME.value()).toPath();
    }
}

