/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JRE {
    public static int majorVersion() {
        String jre = System.getProperty("java.version");
        if (jre.startsWith("1.8")) {
            return 8;
        }
        Matcher matcher = Pattern.compile("(\\d+)").matcher(jre);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Expected " + jre + " to start with an integer");
        }
        int version = Integer.parseInt(matcher.group(1));
        if (version <= 8) {
            throw new IllegalArgumentException("Expected " + jre + " to start with an integer greater than 8");
        }
        return version;
    }

    public static URL[] getClasspath(ClassLoader classLoader) throws Exception {
        URL[] urls;
        if (classLoader instanceof URLClassLoader) {
            urls = ((URLClassLoader)classLoader).getURLs();
        } else {
            Field ucpFld;
            Class<?> clz = classLoader.getClass();
            try {
                ucpFld = clz.getDeclaredField("ucp");
            }
            catch (NoSuchFieldException e) {
                ucpFld = clz.getSuperclass().getDeclaredField("ucp");
            }
            ucpFld.setAccessible(true);
            Object ucpObj = ucpFld.get(classLoader);
            Field pathFld = ucpObj.getClass().getDeclaredField("path");
            pathFld.setAccessible(true);
            List pathObj = (List)pathFld.get(ucpObj);
            urls = pathObj.toArray(new URL[pathObj.size()]);
        }
        return JRE.extractLongClasspathJar(urls);
    }

    private static URL[] extractLongClasspathJar(URL[] in) throws IOException {
        if (in == null || in.length == 0) {
            return new URL[0];
        }
        File only = new File(in[0].getFile());
        if (in.length == 1 && only.getName().startsWith("long-classpath")) {
            ArrayList<URL> urls = new ArrayList<URL>();
            try (JarFile file = new JarFile(only);){
                String cp = file.getManifest().getMainAttributes().getValue("Class-Path");
                for (String entry : cp.split(" ")) {
                    urls.add(new URL(entry));
                }
            }
            return urls.toArray(new URL[0]);
        }
        return in;
    }
}

