/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.oomph;

import com.diffplug.common.base.Errors;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.GoomphCacheLocations;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.gradle.api.Project;

public class WorkspaceRegistry {
    final File root;
    final Map<File, File> ownerToWorkspace = new HashMap<File, File>();
    static final String OWNER_PATH = "-owner";

    public static WorkspaceRegistry instance() throws IOException {
        return new WorkspaceRegistry(GoomphCacheLocations.workspaces());
    }

    WorkspaceRegistry(File root) throws IOException {
        this.root = Objects.requireNonNull(root);
        FileMisc.mkdirs(root);
        for (File workspace : FileMisc.list(root)) {
            if (!workspace.isDirectory()) continue;
            Optional<String> ownerPath = FileMisc.readToken(root, workspace.getName() + OWNER_PATH);
            if (!ownerPath.isPresent()) {
                this.deleteWorkspace(workspace, "missing token -owner.");
                continue;
            }
            this.ownerToWorkspace.put(new File(ownerPath.get()), workspace);
        }
    }

    public File workspaceDir(Project project, File ideDir) {
        return this.workspaceDir(project.getRootProject().getName(), ideDir);
    }

    public File workspaceDir(String name, File ideDir) {
        return this.ownerToWorkspace.computeIfAbsent(ideDir, owner -> {
            File workspace = new File(this.root, name + "-" + owner.getAbsolutePath().hashCode());
            FileMisc.mkdirs(workspace);
            Errors.rethrow().run(() -> FileMisc.writeToken(this.root, workspace.getName() + OWNER_PATH, ideDir.getAbsolutePath()));
            return workspace;
        });
    }

    public void clean() {
        Iterator<Map.Entry<File, File>> iter = this.ownerToWorkspace.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<File, File> entry = iter.next();
            File ownerDir = entry.getKey();
            File workspaceDir = entry.getValue();
            if (ownerDir.exists()) continue;
            this.deleteWorkspace(workspaceDir, "owner " + String.valueOf(ownerDir) + " no longer exists.");
            iter.remove();
        }
    }

    private void deleteWorkspace(File workspace, String reason) {
        try {
            FileMisc.forceDelete(workspace);
            File token = new File(this.root, workspace.getName() + OWNER_PATH);
            FileMisc.forceDelete(token);
        }
        catch (Exception e) {
            System.err.println("Tried to delete workspace " + workspace.getAbsolutePath() + " because " + reason);
            e.printStackTrace();
        }
    }
}

