/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.io.FileWriteMode;
import com.diffplug.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Action;
import org.gradle.api.XmlProvider;
import org.gradle.internal.xml.XmlTransformer;

public class ConfigMisc {
    public static void modifyXmlInPlace(File file, Action<XmlProvider> action) throws IOException {
        String original = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
        XmlTransformer transformer = new XmlTransformer();
        transformer.addAction(action);
        try (OutputStream output = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]).openBufferedStream();){
            transformer.transform(original, output);
        }
    }

    public static void writeProps(Map<String, String> map, File dest) throws IOException {
        Properties properties = new Properties();
        map.forEach((key, value) -> properties.put(key, value));
        try (OutputStream output = Files.asByteSink((File)dest, (FileWriteMode[])new FileWriteMode[0]).openBufferedStream();){
            properties.store(output, "");
        }
    }

    public static Map<String, String> loadProps(File file) throws IOException {
        Properties props = new Properties();
        try (InputStream input = Files.asByteSource((File)file).openBufferedStream();){
            props.load(input);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(props.size());
        for (String key : props.stringPropertyNames()) {
            map.put(key, props.getProperty(key));
        }
        return map;
    }
}

