/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.kotlin;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class KtLintStep {
    private static final String DEFAULT_VERSION = "1.0.0";
    static final String NAME = "ktlint";
    static final String MAVEN_COORDINATE_0_DOT = "com.pinterest:ktlint:";
    static final String MAVEN_COORDINATE_1_DOT = "com.pinterest.ktlint:ktlint-cli:";

    private KtLintStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return KtLintStep.create(KtLintStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return KtLintStep.create(version, provisioner, Collections.emptyMap(), Collections.emptyMap());
    }

    public static FormatterStep create(String version, Provisioner provisioner, Map<String, String> userData, Map<String, Object> editorConfigOverride) {
        return KtLintStep.create(version, provisioner, false, null, userData, editorConfigOverride);
    }

    public static FormatterStep createForScript(String version, Provisioner provisioner) {
        return KtLintStep.create(version, provisioner, true, null, Collections.emptyMap(), Collections.emptyMap());
    }

    public static FormatterStep createForScript(String version, Provisioner provisioner, @Nullable FileSignature editorConfigPath, Map<String, String> userData, Map<String, Object> editorConfigOverride) {
        return KtLintStep.create(version, provisioner, true, editorConfigPath, userData, editorConfigOverride);
    }

    public static FormatterStep create(String version, Provisioner provisioner, boolean isScript, @Nullable FileSignature editorConfig, Map<String, String> userData, Map<String, Object> editorConfigOverride) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(version, provisioner, isScript, editorConfig, userData, editorConfigOverride), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean isScript;
        final JarState jarState;
        private final TreeMap<String, String> userData;
        private final TreeMap<String, Object> editorConfigOverride;
        private final String version;
        @Nullable
        private final FileSignature editorConfigPath;

        State(String version, Provisioner provisioner, boolean isScript, @Nullable FileSignature editorConfigPath, Map<String, String> userData, Map<String, Object> editorConfigOverride) throws IOException {
            this.version = version;
            this.userData = new TreeMap<String, String>(userData);
            this.editorConfigOverride = new TreeMap<String, Object>(editorConfigOverride);
            this.jarState = JarState.from((version.startsWith("0.") ? KtLintStep.MAVEN_COORDINATE_0_DOT : KtLintStep.MAVEN_COORDINATE_1_DOT) + version, provisioner);
            this.editorConfigPath = editorConfigPath;
            this.isScript = isScript;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.ktlint.KtlintFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(String.class, Boolean.TYPE, FileSignature.class, Map.class, Map.class);
            return (FormatterFunc.NeedsFile)constructor.newInstance(this.version, this.isScript, this.editorConfigPath, this.userData, this.editorConfigOverride);
        }
    }
}

