/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.ConfigurationCacheHackList;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.Lint;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FenceStep {
    String name;
    Pattern regex;

    public static FenceStep named(String name) {
        return new FenceStep(name);
    }

    public static String defaultToggleName() {
        return "toggle";
    }

    public static String defaultToggleOff() {
        return "spotless:off";
    }

    public static String defaultToggleOn() {
        return "spotless:on";
    }

    private FenceStep(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public FenceStep openClose(String open, String close) {
        return this.regex(Pattern.quote(open) + "([\\s\\S]*?)" + Pattern.quote(close));
    }

    public FenceStep regex(String regex) {
        return this.regex(Pattern.compile(regex));
    }

    public FenceStep regex(Pattern regex) {
        this.regex = Objects.requireNonNull(regex);
        return this;
    }

    private void assertRegexSet() {
        Objects.requireNonNull(this.regex, "must call regex() or openClose()");
    }

    public FormatterStep preserveWithin(List<FormatterStep> steps) {
        return this.createStep(Kind.PRESERVE, steps);
    }

    public FormatterStep applyWithin(List<FormatterStep> steps) {
        return this.createStep(Kind.APPLY, steps);
    }

    private FormatterStep createStep(Kind kind, List<FormatterStep> steps) {
        this.assertRegexSet();
        return FormatterStep.createLazy(this.name, () -> new RoundtripAndEqualityState(kind, this.regex, steps, false), RoundtripAndEqualityState::toEqualityState, RoundtripAndEqualityState::toFormatterFunc);
    }

    private static enum Kind {
        APPLY,
        PRESERVE;

    }

    private static final class RoundtripAndEqualityState
    implements Serializable {
        private static final long serialVersionUID = 272603249547598947L;
        final String regexPattern;
        final int regexFlags;
        final Kind kind;
        final ConfigurationCacheHackList steps;

        private RoundtripAndEqualityState(Kind kind, Pattern regex, List<FormatterStep> steps, boolean optimizeForEquality) {
            this.kind = kind;
            this.regexPattern = regex.pattern();
            this.regexFlags = regex.flags();
            this.steps = optimizeForEquality ? ConfigurationCacheHackList.forEquality() : ConfigurationCacheHackList.forRoundtrip();
            this.steps.addAll(steps);
        }

        private Pattern regex() {
            return Pattern.compile(this.regexPattern, this.regexFlags);
        }

        private List<FormatterStep> steps() {
            return this.steps.getSteps();
        }

        public RoundtripAndEqualityState toEqualityState() {
            return new RoundtripAndEqualityState(this.kind, this.regex(), this.steps(), true);
        }

        public BaseFormatter toFormatterFunc() {
            return new BaseFormatter(this.kind, this);
        }
    }

    private static class BaseFormatter
    implements FormatterFunc.NeedsFile,
    FormatterFunc.Closeable {
        final Kind kind;
        final Pattern regex;
        final List<FormatterStep> steps;
        final ArrayList<String> groups = new ArrayList();
        final StringBuilder builderInternal = new StringBuilder();
        private Formatter formatter;

        public BaseFormatter(Kind kind, RoundtripAndEqualityState state) {
            this.kind = kind;
            this.regex = state.regex();
            this.steps = state.steps();
        }

        protected ArrayList<String> groupsZeroed() {
            this.groups.clear();
            return this.groups;
        }

        private StringBuilder builderZeroed() {
            this.builderInternal.setLength(0);
            return this.builderInternal;
        }

        protected Formatter buildFormatter() {
            return Formatter.builder().encoding(StandardCharsets.UTF_8).lineEndingsPolicy(LineEnding.UNIX.createPolicy()).steps(this.steps).build();
        }

        protected String assembleGroups(String unix) {
            if (this.groups.isEmpty()) {
                return unix;
            }
            StringBuilder builder = this.builderZeroed();
            Matcher matcher = this.regex.matcher(unix);
            int lastEnd = 0;
            int groupIdx = 0;
            while (matcher.find()) {
                builder.append(unix, lastEnd, matcher.start(1));
                builder.append(this.groups.get(groupIdx));
                lastEnd = matcher.end(1);
                ++groupIdx;
            }
            if (groupIdx == this.groups.size()) {
                builder.append(unix, lastEnd, unix.length());
                return builder.toString();
            }
            int startLine = 1 + (int)builder.toString().codePoints().filter(c -> c == 10).count();
            int endLine = 1 + (int)unix.codePoints().filter(c -> c == 10).count();
            Matcher openClose = Pattern.compile("\\\\Q([\\s\\S]*?)\\\\E\\Q([\\s\\S]*?)\\E\\\\Q([\\s\\S]*?)\\\\E").matcher(this.regex.pattern());
            Object pattern = openClose.matches() ? openClose.group(1) + " " + openClose.group(2) : this.regex.pattern();
            throw Lint.atLineRange(startLine, endLine, "fenceRemoved", "An intermediate step removed a match of " + (String)pattern).shortcut();
        }

        @Override
        public String applyWithFile(String unix, File file) throws Exception {
            if (this.formatter == null) {
                this.formatter = this.buildFormatter();
            }
            ArrayList<String> groups = this.groupsZeroed();
            Matcher matcher = this.regex.matcher(unix);
            switch (this.kind.ordinal()) {
                case 0: {
                    while (matcher.find()) {
                        groups.add(this.formatter.compute(matcher.group(1), file));
                    }
                    return this.assembleGroups(unix);
                }
                case 1: {
                    while (matcher.find()) {
                        groups.add(matcher.group(1));
                    }
                    String formatted = this.formatter.compute(unix, file);
                    return this.assembleGroups(formatted);
                }
            }
            throw new Error();
        }

        @Override
        public void close() {
            if (this.formatter != null) {
                this.formatter.close();
                this.formatter = null;
            }
        }
    }
}

