/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.java.ModuleHelper;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public final class CleanthatJavaStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "cleanthat";
    private static final String MAVEN_COORDINATE = "io.github.solven-eu.cleanthat:java";
    private static final Jvm.Support<String> JVM_SUPPORT = Jvm.support("cleanthat").add(11, "2.24");
    private final JarState.Promised jarState;
    private final String version;
    private final String sourceJdkVersion;
    private final List<String> included;
    private final List<String> excluded;
    private final boolean includeDraft;

    private CleanthatJavaStep(JarState.Promised jarState, String version, String sourceJdkVersion, List<String> included, List<String> excluded, boolean includeDraft) {
        this.jarState = jarState;
        this.version = version;
        this.sourceJdkVersion = sourceJdkVersion;
        this.included = included;
        this.excluded = excluded;
        this.includeDraft = includeDraft;
    }

    public static FormatterStep create(Provisioner provisioner) {
        return CleanthatJavaStep.create(CleanthatJavaStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return CleanthatJavaStep.createWithStepName(NAME, MAVEN_COORDINATE, version, CleanthatJavaStep.defaultSourceJdk(), CleanthatJavaStep.defaultMutators(), CleanthatJavaStep.defaultExcludedMutators(), CleanthatJavaStep.defaultIncludeDraft(), provisioner);
    }

    public static String defaultSourceJdk() {
        return "1.7";
    }

    public static List<String> defaultMutators() {
        return List.of("SafeAndConsensual");
    }

    public static List<String> defaultExcludedMutators() {
        return List.of();
    }

    public static boolean defaultIncludeDraft() {
        return false;
    }

    static FormatterStep createWithStepName(String stepName, String groupArtifact, String version, String sourceJdkVersion, List<String> included, List<String> excluded, boolean includeDraft, Provisioner provisioner) {
        Objects.requireNonNull(groupArtifact, "groupArtifact");
        if (groupArtifact.chars().filter(ch -> ch == 58).count() != 1L) {
            throw new IllegalArgumentException("groupArtifact must be in the form 'groupId:artifactId'. it was: " + groupArtifact);
        }
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.create(stepName, new CleanthatJavaStep(JarState.promise(() -> JarState.from(groupArtifact + ":" + version, provisioner)), version, sourceJdkVersion, included, excluded, includeDraft), CleanthatJavaStep::equalityState, State::createFormat);
    }

    public static FormatterStep create(String groupArtifact, String version, String sourceJdkVersion, List<String> included, List<String> excluded, boolean includeDraft, Provisioner provisioner) {
        return CleanthatJavaStep.createWithStepName(NAME, groupArtifact, version, sourceJdkVersion, included, excluded, includeDraft, provisioner);
    }

    public static String defaultVersion() {
        return Objects.requireNonNull(JVM_SUPPORT.getRecommendedFormatterVersion());
    }

    public static String defaultGroupArtifact() {
        return MAVEN_COORDINATE;
    }

    private State equalityState() {
        return new State(this.jarState.get(), this.version, this.sourceJdkVersion, this.included, this.excluded, this.includeDraft);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JarState jarState;
        private final String version;
        private final String sourceJdkVersion;
        private final List<String> included;
        private final List<String> excluded;
        private final boolean includeDraft;

        State(JarState jarState, String version, String sourceJdkVersion, List<String> included, List<String> excluded, boolean includeDraft) {
            JVM_SUPPORT.assertFormatterSupported(version);
            ModuleHelper.doOpenInternalPackagesIfRequired();
            this.jarState = jarState;
            this.version = version;
            this.sourceJdkVersion = sourceJdkVersion;
            this.included = included;
            this.excluded = excluded;
            this.includeDraft = includeDraft;
        }

        FormatterFunc createFormat() {
            Method formatterMethod;
            Object formatter;
            ClassLoader classLoader = this.jarState.getClassLoader();
            try {
                Class<?> formatterClazz = classLoader.loadClass("com.diffplug.spotless.glue.java.JavaCleanthatRefactorerFunc");
                Constructor<?> formatterConstructor = formatterClazz.getConstructor(String.class, List.class, List.class, Boolean.TYPE);
                formatter = formatterConstructor.newInstance(this.sourceJdkVersion, this.included, this.excluded, this.includeDraft);
                formatterMethod = formatterClazz.getMethod("apply", String.class, File.class);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Issue executing the formatter", e);
            }
            JvmSupportFormatterFunc formatterFunc = new JvmSupportFormatterFunc(formatter, formatterMethod);
            return JVM_SUPPORT.suggestLaterVersionOnError(this.version, formatterFunc);
        }

        private static final class JvmSupportFormatterFunc
        implements FormatterFunc {
            final Object formatter;
            final Method formatterMethod;

            private JvmSupportFormatterFunc(Object formatter, Method formatterMethod) {
                this.formatter = formatter;
                this.formatterMethod = formatterMethod;
            }

            @Override
            public String apply(String input) throws Exception {
                return this.apply(input, Formatter.NO_FILE_SENTINEL);
            }

            @Override
            public String apply(String input, File file) throws Exception {
                if (file.isAbsolute()) {
                    Path absolutePath = file.toPath();
                    file = absolutePath.subpath(1, absolutePath.getNameCount()).toFile();
                }
                return (String)this.formatterMethod.invoke(this.formatter, input, file);
            }
        }
    }
}

