/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.json.gson;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.json.gson.GsonConfig;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public final class GsonStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MAVEN_COORDINATES = "com.google.code.gson:gson";
    private static final String INCOMPATIBLE_ERROR_MESSAGE = "There was a problem interacting with Gson; maybe you set an incompatible version?";
    public static final String NAME = "gson";
    public static final String DEFAULT_VERSION = "2.13.2";
    private final JarState.Promised jarState;
    private final GsonConfig gsonConfig;

    private GsonStep(JarState.Promised jarState, GsonConfig gsonConfig) {
        this.gsonConfig = gsonConfig;
        this.jarState = jarState;
    }

    public static FormatterStep create(GsonConfig gsonConfig, Provisioner provisioner) {
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.create(NAME, new GsonStep(JarState.promise(() -> JarState.from("com.google.code.gson:gson:" + gsonConfig.getVersion(), provisioner)), gsonConfig), GsonStep::equalityState, State::toFormatter);
    }

    private State equalityState() {
        return new State(this.jarState.get(), this.gsonConfig);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = -3240568265160440420L;
        private final JarState jarState;
        private final GsonConfig gsonConfig;

        private State(JarState jarState, GsonConfig gsonConfig) {
            this.jarState = jarState;
            this.gsonConfig = gsonConfig;
        }

        FormatterFunc toFormatter() {
            try {
                Class<?> formatterFunc = this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.gson.GsonFormatterFunc");
                Constructor<?> constructor = formatterFunc.getConstructor(GsonConfig.class);
                return (FormatterFunc)constructor.newInstance(this.gsonConfig);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException cause) {
                throw new IllegalStateException(GsonStep.INCOMPATIBLE_ERROR_MESSAGE, cause);
            }
        }
    }
}

