/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.cli;

import com.facebook.ktfmt.cli.MainKt;
import com.facebook.ktfmt.cli.ParseResult;
import com.facebook.ktfmt.cli.ParsedArgs;
import com.facebook.ktfmt.format.Formatter;
import com.facebook.ktfmt.format.ParseError;
import com.google.common.collect.UnmodifiableIterator;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.FormattingError;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/facebook/ktfmt/cli/Main;", "", "input", "Ljava/io/InputStream;", "out", "Ljava/io/PrintStream;", "err", "inputArgs", "", "", "<init>", "(Ljava/io/InputStream;Ljava/io/PrintStream;Ljava/io/PrintStream;[Ljava/lang/String;)V", "[Ljava/lang/String;", "run", "", "format", "", "file", "Ljava/io/File;", "args", "Lcom/facebook/ktfmt/cli/ParsedArgs;", "Companion", "ktfmt"})
@SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\ncom/facebook/ktfmt/cli/Main\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class Main {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputStream input;
    @NotNull
    private final PrintStream out;
    @NotNull
    private final PrintStream err;
    @NotNull
    private final String[] inputArgs;

    public Main(@NotNull InputStream input, @NotNull PrintStream out, @NotNull PrintStream err, @NotNull String[] inputArgs) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        Intrinsics.checkNotNullParameter((Object)inputArgs, (String)"inputArgs");
        this.input = input;
        this.out = out;
        this.err = err;
        this.inputArgs = inputArgs;
    }

    public final int run() {
        ParseResult processArgs = ParsedArgs.Companion.processArgs(this.inputArgs);
        if (!(processArgs instanceof ParseResult.Ok)) {
            if (processArgs instanceof ParseResult.ShowMessage) {
                this.out.println(((ParseResult.ShowMessage)processArgs).getMessage());
                return 0;
            }
            if (processArgs instanceof ParseResult.Error) {
                this.err.println(((ParseResult.Error)processArgs).getErrorMessage());
                return 1;
            }
            throw new NoWhenBranchMatchedException();
        }
        ParsedArgs parsedArgs = ((ParseResult.Ok)processArgs).getParsedValue();
        if (parsedArgs.getFileNames().isEmpty()) {
            this.err.println(MainKt.access$getUSAGE$p());
            return 1;
        }
        if (parsedArgs.getFileNames().size() == 1 && Intrinsics.areEqual((Object)parsedArgs.getFileNames().get(0), (Object)"-")) {
            int alreadyFormatted;
            try {
                alreadyFormatted = this.format(null, parsedArgs);
                alreadyFormatted = alreadyFormatted == 0 && parsedArgs.getSetExitIfChanged() ? 1 : 0;
            }
            catch (Exception exception) {
                alreadyFormatted = 1;
            }
            return alreadyFormatted;
        }
        List<File> files = Companion.expandArgsToFileNames(parsedArgs.getFileNames());
        if (files.isEmpty()) {
            this.err.println("Error: no .kt files found");
            return 1;
        }
        AtomicInteger returnCode = new AtomicInteger(0);
        files.parallelStream().forEach(arg_0 -> Main.run$lambda$1(arg_0 -> Main.run$lambda$0(this, parsedArgs, returnCode, arg_0), arg_0));
        return returnCode.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean format(File file, ParsedArgs args) {
        Object object = file;
        if ((object == null || (object = ((File)object).toString()) == null) && (object = args.getStdinName()) == null) {
            object = "<stdin>";
        }
        Object fileName = object;
        try {
            InputStream bytes = file == null ? this.input : (InputStream)new FileInputStream(file);
            String code = TextStreamsKt.readText((Reader)new BufferedReader(new InputStreamReader(bytes, StandardCharsets.UTF_8)));
            String formattedCode = Formatter.format(args.getFormattingOptions(), code);
            boolean alreadyFormatted = Intrinsics.areEqual((Object)code, (Object)formattedCode);
            if (file == null) {
                if (args.getDryRun()) {
                    if (!alreadyFormatted) {
                        this.out.println((String)fileName);
                    }
                } else {
                    Closeable closeable = new BufferedWriter(new OutputStreamWriter((OutputStream)this.out, StandardCharsets.UTF_8));
                    Throwable throwable = null;
                    try {
                        BufferedWriter it = (BufferedWriter)closeable;
                        boolean bl = false;
                        it.write(formattedCode);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                return alreadyFormatted;
            }
            if (args.getDryRun()) {
                if (!alreadyFormatted) {
                    this.out.println((String)fileName);
                }
            } else {
                if (!alreadyFormatted) {
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    FilesKt.writeText((File)file, (String)formattedCode, (Charset)charset);
                }
                this.err.println("Done formatting " + (String)fileName);
            }
            return alreadyFormatted;
        }
        catch (IOException e) {
            this.err.println("Error formatting " + (String)fileName + ": " + e.getMessage() + "; skipping.");
            throw e;
        }
        catch (ParseError e) {
            this.err.println((String)fileName + ":" + e.getMessage());
            throw e;
        }
        catch (FormattingError e) {
            UnmodifiableIterator unmodifiableIterator = e.diagnostics().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
            UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
            while (unmodifiableIterator2.hasNext()) {
                FormatterDiagnostic diagnostic = (FormatterDiagnostic)unmodifiableIterator2.next();
                this.err.println((String)fileName + ":" + diagnostic);
            }
            e.printStackTrace(this.err);
            throw e;
        }
    }

    private static final Unit run$lambda$0(Main this$0, ParsedArgs $parsedArgs, AtomicInteger $returnCode, File it) {
        try {
            if (!this$0.format(it, $parsedArgs) && $parsedArgs.getSetExitIfChanged()) {
                $returnCode.set(1);
            }
        }
        catch (Exception exception) {
            $returnCode.set(1);
        }
        return Unit.INSTANCE;
    }

    private static final void run$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u00a8\u0006\r"}, d2={"Lcom/facebook/ktfmt/cli/Main$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "expandArgsToFileNames", "", "Ljava/io/File;", "ktfmt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"in");
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
            PrintStream printStream2 = System.err;
            Intrinsics.checkNotNullExpressionValue((Object)printStream2, (String)"err");
            System.exit(new Main(inputStream, printStream, printStream2, args).run());
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }

        @NotNull
        public final List<File> expandArgsToFileNames(@NotNull List<String> args) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            if (args.size() == 1 && new File(args.get(0)).isFile()) {
                return CollectionsKt.listOf((Object)new File(args.get(0)));
            }
            List result2 = new ArrayList();
            for (String arg : args) {
                CollectionsKt.addAll((Collection)result2, (Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)new File(arg))), Companion::expandArgsToFileNames$lambda$0));
            }
            return result2;
        }

        private static final boolean expandArgsToFileNames$lambda$0(File it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.isFile() && (Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"kt") || Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"kts"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

