/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.facebook.ktfmt.format.KotlinTok;
import com.facebook.ktfmt.format.ParseError;
import com.facebook.ktfmt.format.WhitespaceTombstones;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.LineColumn;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/facebook/ktfmt/format/Tokenizer;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "fileText", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtFile;)V", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "toks", "", "Lcom/facebook/ktfmt/format/KotlinTok;", "getToks", "()Ljava/util/List;", "value", "", "index", "getIndex", "()I", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitElement", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Companion", "ktfmt"})
public final class Tokenizer
extends KtTreeVisitorVoid {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fileText;
    @NotNull
    private final KtFile file;
    @NotNull
    private final List<KotlinTok> toks;
    private int index;
    @NotNull
    private static final Pattern WHITESPACE_NEWLINE_REGEX;

    public Tokenizer(@NotNull String fileText, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.fileText = fileText;
        this.file = file;
        this.toks = new ArrayList();
    }

    @NotNull
    public final KtFile getFile() {
        return this.file;
    }

    @NotNull
    public final List<KotlinTok> getToks() {
        return this.toks;
    }

    public final int getIndex() {
        return this.index;
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.visitExpression((KtExpression)expression);
    }

    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        int startIndex = PsiUtilsKt.getStartOffset((PsiElement)element);
        int endIndex = PsiUtilsKt.getEndOffset((PsiElement)element);
        String elementText = element.getText();
        String string = this.fileText.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String originalText = string;
        PsiElement psiElement = element;
        if (psiElement instanceof PsiComment) {
            String string2 = ((PsiComment)element).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (StringsKt.startsWith$default((String)string2, (String)"/*", (boolean)false, (int)2, null)) {
                String string3 = ((PsiComment)element).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                if (!StringsKt.endsWith$default((String)string3, (String)"*/", (boolean)false, (int)2, null)) {
                    LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)this.fileText, (int)PsiUtilsKt.getStartOffset((PsiElement)element));
                    Intrinsics.checkNotNullExpressionValue((Object)lineColumn, (String)"offsetToLineColumn(...)");
                    throw new ParseError("Unclosed comment", lineColumn);
                }
            }
            Intrinsics.checkNotNull((Object)elementText);
            KtToken ktToken = KtTokens.EOF;
            Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"EOF");
            this.toks.add(new KotlinTok(this.index, originalText, elementText, startIndex, 0, false, ktToken));
            int n = this.index;
            this.index = n + 1;
            return;
        }
        if (psiElement instanceof KtStringTemplateExpression) {
            String string4 = WhitespaceTombstones.INSTANCE.replaceTrailingWhitespaceWithTombstone(originalText);
            Intrinsics.checkNotNull((Object)elementText);
            KtToken ktToken = KtTokens.EOF;
            Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"EOF");
            this.toks.add(new KotlinTok(this.index, string4, elementText, startIndex, 0, true, ktToken));
            int n = this.index;
            this.index = n + 1;
            return;
        }
        if (psiElement instanceof LeafPsiElement) {
            if (element instanceof PsiWhiteSpace) {
                Matcher matcher = WHITESPACE_NEWLINE_REGEX.matcher(elementText);
                while (matcher.find()) {
                    String text = matcher.group();
                    String string5 = this.fileText.substring(startIndex + matcher.start(), startIndex + matcher.end());
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    Intrinsics.checkNotNull((Object)text);
                    int n = startIndex + matcher.start();
                    KtToken ktToken = KtTokens.EOF;
                    Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"EOF");
                    this.toks.add(new KotlinTok(-1, string5, text, n, 0, false, ktToken));
                }
            } else {
                Intrinsics.checkNotNull((Object)elementText);
                KtToken ktToken = KtTokens.EOF;
                Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"EOF");
                this.toks.add(new KotlinTok(this.index, originalText, elementText, startIndex, 0, true, ktToken));
                int n = this.index;
                this.index = n + 1;
            }
        }
        super.visitElement(element);
    }

    static {
        Pattern pattern = Pattern.compile("\\R|( )+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        WHITESPACE_NEWLINE_REGEX = pattern;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/ktfmt/format/Tokenizer$Companion;", "", "<init>", "()V", "WHITESPACE_NEWLINE_REGEX", "Ljava/util/regex/Pattern;", "ktfmt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

