/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.facebook.ktfmt.debughelpers.OpsDebugKt;
import com.facebook.ktfmt.format.FormattingOptions;
import com.facebook.ktfmt.format.KotlinInput;
import com.facebook.ktfmt.format.KotlinInputAstVisitor;
import com.facebook.ktfmt.format.MultilineStringFormatter;
import com.facebook.ktfmt.format.ParseError;
import com.facebook.ktfmt.format.Parser;
import com.facebook.ktfmt.format.RedundantElementManager;
import com.facebook.ktfmt.format.TrailingCommaManagementStrategy;
import com.facebook.ktfmt.format.WhitespaceTombstones;
import com.facebook.ktfmt.kdoc.Escaping;
import com.facebook.ktfmt.kdoc.KDocCommentsHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.DocBuilder;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.Output;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.LineColumn;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000bH\u0007J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/ktfmt/format/Formatter;", "", "<init>", "()V", "META_FORMAT", "Lcom/facebook/ktfmt/format/FormattingOptions;", "GOOGLE_FORMAT", "KOTLINLANG_FORMAT", "MINIMUM_KOTLIN_VERSION", "Lkotlin/KotlinVersion;", "format", "", "code", "removeUnusedImports", "", "options", "prettyPrint", "lineSeparator", "createAstVisitor", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElementVisitor;", "builder", "Lcom/google/googlejavaformat/OpsBuilder;", "checkEscapeSequences", "", "sortedAndDistinctImports", "ktfmt"})
@SourceDebugExtension(value={"SMAP\nFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Formatter.kt\ncom/facebook/ktfmt/format/Formatter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1#2:200\n1056#3:201\n1669#3,8:202\n*S KotlinDebug\n*F\n+ 1 Formatter.kt\ncom/facebook/ktfmt/format/Formatter\n*L\n189#1:201\n189#1:202,8\n*E\n"})
public final class Formatter {
    @NotNull
    public static final Formatter INSTANCE = new Formatter();
    @JvmField
    @NotNull
    public static final FormattingOptions META_FORMAT = new FormattingOptions(0, 2, 4, TrailingCommaManagementStrategy.ONLY_ADD, false, false, 49, null);
    @JvmField
    @NotNull
    public static final FormattingOptions GOOGLE_FORMAT = new FormattingOptions(0, 2, 2, null, false, false, 57, null);
    @JvmField
    @NotNull
    public static final FormattingOptions KOTLINLANG_FORMAT = new FormattingOptions(0, 4, 4, null, false, false, 57, null);
    @NotNull
    private static final KotlinVersion MINIMUM_KOTLIN_VERSION = new KotlinVersion(1, 4);

    private Formatter() {
    }

    @JvmStatic
    @NotNull
    public static final String format(@NotNull String code) throws FormatterException, ParseError {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return Formatter.format(META_FORMAT, code);
    }

    @JvmStatic
    @NotNull
    public static final String format(@NotNull String code, boolean removeUnusedImports) throws FormatterException, ParseError {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return Formatter.format(FormattingOptions.copy$default(META_FORMAT, 0, 0, 0, null, removeUnusedImports, false, 47, null), code);
    }

    @JvmStatic
    @NotNull
    public static final String format(@NotNull FormattingOptions options, @NotNull String code) throws FormatterException, ParseError {
        List list;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        if (StringsKt.startsWith$default((String)code, (String)"#!", (boolean)false, (int)2, null)) {
            var3_2 = (Object[])code;
            Regex regex = new Regex("\n");
            int n = 2;
            list = regex.split((CharSequence)var3_2, n);
        } else {
            var3_2 = new String[]{"", code};
            list = CollectionsKt.listOf((Object[])var3_2);
        }
        List list2 = list;
        String shebang = (String)list2.get(0);
        String kotlinCode = (String)list2.get(1);
        INSTANCE.checkEscapeSequences(kotlinCode);
        String it = kotlinCode;
        boolean bl = false;
        it = StringUtilRt.convertLineSeparators((String)it);
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it);
        it = INSTANCE.sortedAndDistinctImports(it);
        boolean bl3 = false;
        it = RedundantElementManager.INSTANCE.dropRedundantElements(it, options);
        boolean bl4 = false;
        it = INSTANCE.prettyPrint(it, options, "\n");
        boolean bl5 = false;
        it = RedundantElementManager.INSTANCE.addRedundantElements(it, options);
        boolean bl6 = false;
        it = new MultilineStringFormatter(options.getContinuationIndent()).format(it);
        boolean bl7 = false;
        String string = Newlines.guessLineSeparator((String)kotlinCode);
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        it = StringUtilRt.convertLineSeparators((String)it, (String)string);
        boolean bl8 = false;
        Object object = ((CharSequence)shebang).length() == 0 ? it : shebang + "\n" + it;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"let(...)");
        return object;
    }

    private final String prettyPrint(String code, FormattingOptions options, String lineSeparator) {
        KtFile file = Parser.INSTANCE.parse(code);
        KotlinInput kotlinInput = new KotlinInput(code, file);
        JavaOutput javaOutput = new JavaOutput(lineSeparator, (Input)kotlinInput, (CommentsHelper)new KDocCommentsHelper(lineSeparator, options.getMaxWidth()));
        OpsBuilder builder = new OpsBuilder((Input)kotlinInput, (Output)javaOutput);
        file.accept(this.createAstVisitor(options, builder));
        builder.sync(kotlinInput.getText().length());
        builder.drain();
        ImmutableList ops = builder.build();
        if (options.getDebuggingPrintOpsAfterFormatting()) {
            Intrinsics.checkNotNull((Object)ops);
            OpsDebugKt.printOps((ImmutableList<Op>)ops);
        }
        Doc doc = new DocBuilder().withOps((List)ops).build();
        doc.computeBreaks(javaOutput.getCommentsHelper(), options.getMaxWidth(), new Doc.State(0, 0));
        doc.write((Output)javaOutput);
        javaOutput.flush();
        ImmutableList immutableList = ImmutableList.of((Object)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(code.length())));
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
        RangeSet<Integer> tokenRangeSet = kotlinInput.characterRangesToTokenRanges((Collection)immutableList);
        String string = JavaOutput.applyReplacements((String)code, (List)((List)javaOutput.getFormatReplacements(tokenRangeSet)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"applyReplacements(...)");
        return WhitespaceTombstones.INSTANCE.replaceTombstoneWithTrailingWhitespace(string);
    }

    private final PsiElementVisitor createAstVisitor(FormattingOptions options, OpsBuilder builder) {
        if (KotlinVersion.CURRENT.compareTo(MINIMUM_KOTLIN_VERSION) < 0) {
            throw new RuntimeException("Unsupported runtime Kotlin version: " + KotlinVersion.CURRENT);
        }
        return (PsiElementVisitor)new KotlinInputAstVisitor(options, builder);
    }

    private final void checkEscapeSequences(String code) {
        int index = WhitespaceTombstones.INSTANCE.indexOfWhitespaceTombstone(code);
        if (index == -1) {
            index = Escaping.INSTANCE.indexOfCommentEscapeSequences(code);
        }
        if (index != -1) {
            LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)code, (int)index);
            Intrinsics.checkNotNullExpressionValue((Object)lineColumn, (String)"offsetToLineColumn(...)");
            throw new ParseError("ktfmt does not support code which contains one of {\\u0003, \\u0004, \\u0005} character; escape it", lineColumn);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String sortedAndDistinctImports(String code) {
        void $this$distinctBy$iv;
        KtFile file = Parser.INSTANCE.parse(code);
        KtImportList ktImportList = file.getImportList();
        if (ktImportList == null) {
            return code;
        }
        KtImportList importList = ktImportList;
        if (importList.getImports().isEmpty()) {
            return code;
        }
        List commentList = new ArrayList();
        for (PsiElement element = importList.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (element instanceof PsiComment) {
                commentList.add(element);
                continue;
            }
            if (element instanceof KtImportDirective || element instanceof PsiWhiteSpace) continue;
            String string = "Imports not contiguous: " + element.getText();
            LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)code, (int)PsiUtilsKt.getStartOffset((PsiElement)element));
            Intrinsics.checkNotNullExpressionValue((Object)lineColumn, (String)"offsetToLineColumn(...)");
            throw new ParseError(string, lineColumn);
        }
        List list = importList.getImports();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getImports(...)");
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KtImportDirective p0 = (KtImportDirective)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)Formatter.access$sortedAndDistinctImports$canonicalText(p0));
                p0 = (KtImportDirective)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)Formatter.access$sortedAndDistinctImports$canonicalText(p0))));
            }
        });
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            KtImportDirective p0 = (KtImportDirective)e$iv;
            boolean bl = false;
            String key$iv = Formatter.sortedAndDistinctImports$canonicalText(p0);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List sortedImports = list$iv;
        List importsWithComments = CollectionsKt.plus((Collection)commentList, (Iterable)sortedImports);
        String string = code;
        int n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)importList));
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)importList));
        CharSequence charSequence = CollectionsKt.joinToString$default((Iterable)importsWithComments, (CharSequence)"\n", null, null, (int)0, null, Formatter::sortedAndDistinctImports$lambda$9, (int)30, null) + "\n";
        return ((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n2, (CharSequence)charSequence)).toString();
    }

    private static final String sortedAndDistinctImports$canonicalText(KtImportDirective importDirective) {
        Object object;
        FqName fqName = importDirective.getImportedFqName();
        return (fqName != null ? fqName.asString() : null) + " " + ((object = importDirective.getAlias()) != null && (object = object.getText()) != null ? StringsKt.replace$default((String)object, (String)"`", (String)"", (boolean)false, (int)4, null) : null) + " " + (importDirective.isAllUnder() ? "*" : "");
    }

    private static final CharSequence sortedAndDistinctImports$lambda$9(PsiElement imprt) {
        String string = imprt.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public static final /* synthetic */ String access$sortedAndDistinctImports$canonicalText(KtImportDirective importDirective) {
        return Formatter.sortedAndDistinctImports$canonicalText(importDirective);
    }
}

