/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.facebook.ktfmt.format.MultilineTrimmedString;
import com.facebook.ktfmt.format.Parser;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\n\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/facebook/ktfmt/format/MultilineStringFormatter;", "", "continuationIndentSize", "", "<init>", "(I)V", "getContinuationIndentSize", "()I", "format", "", "code", "getMultilineTrimmedStringList", "", "Lcom/facebook/ktfmt/format/MultilineTrimmedString;", "getMultilineTrimmedStringList$ktfmt", "ktfmt"})
@SourceDebugExtension(value={"SMAP\nMultilineStringFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultilineStringFormatter.kt\ncom/facebook/ktfmt/format/MultilineStringFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n1068#2:226\n1869#2,2:227\n*S KotlinDebug\n*F\n+ 1 MultilineStringFormatter.kt\ncom/facebook/ktfmt/format/MultilineStringFormatter\n*L\n37#1:226\n64#1:227,2\n*E\n"})
public final class MultilineStringFormatter {
    private final int continuationIndentSize;

    public MultilineStringFormatter(int continuationIndentSize) {
        this.continuationIndentSize = continuationIndentSize;
    }

    public final int getContinuationIndentSize() {
        return this.continuationIndentSize;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String format(@NotNull String code) {
        void $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        StringBuilder result2 = new StringBuilder(code);
        Iterable iterable = this.getMultilineTrimmedStringList$ktfmt(code);
        boolean $i$f$sortedByDescending = false;
        List multilineStringList = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MultilineTrimmedString p0 = (MultilineTrimmedString)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(p0.getOpenStringOffset());
                p0 = (MultilineTrimmedString)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getOpenStringOffset()));
            }
        });
        for (MultilineTrimmedString multilineString : multilineStringList) {
            if (multilineString.getStringLineCount() < 2 || multilineString.hasTemplateExpression() || multilineString.isNestedMultiline()) continue;
            String indentation = StringsKt.repeat((CharSequence)" ", (int)multilineString.getIndentCount());
            String continuationIndentation = StringsKt.repeat((CharSequence)" ", (int)this.continuationIndentSize);
            StringBuilder multiline = new StringBuilder();
            if (multilineString.isDollarString()) {
                multiline.append("$$");
            }
            multiline.append("\"\"\"");
            multiline.append('\n');
            boolean isLastLineEmpty = false;
            isLastLineEmpty = true;
            Iterable $this$forEach$iv = multilineString.getStringContent();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String lineContent = (String)element$iv;
                boolean bl = false;
                if (multilineString.getUsesTrimMargin() || ((CharSequence)lineContent).length() > 0) {
                    multiline.append(indentation);
                    multiline.append(multilineString.getIndentationSuffix());
                }
                multiline.append(lineContent).append('\n');
                isLastLineEmpty = ((CharSequence)lineContent).length() == 0;
            }
            if (multilineString.getUsesTrimMargin() && isLastLineEmpty) {
                StringBuilder stringBuilder = multiline.deleteCharAt(StringsKt.getLastIndex((CharSequence)multiline));
                v1 = stringBuilder;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"deleteCharAt(...)");
            } else {
                v1 = multiline.append(indentation);
            }
            multiline.append("\"\"\"").append('\n');
            multiline.append(indentation);
            multiline.append(continuationIndentation);
            result2.replace(multilineString.getOpenStringOffset(), multilineString.getTrimMethodCallOffset(), multiline.toString());
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @VisibleForTesting
    @NotNull
    public final List<MultilineTrimmedString> getMultilineTrimmedStringList$ktfmt(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        KtFile file = Parser.INSTANCE.parse(code);
        List strings = new ArrayList();
        file.accept((PsiElementVisitor)new KtTreeVisitorVoid(code, strings){
            final /* synthetic */ String $code;
            final /* synthetic */ List<MultilineTrimmedString> $strings;
            {
                this.$code = $code;
                this.$strings = $strings;
            }

            /*
             * WARNING - void declaration
             */
            public void visitQualifiedExpression(KtQualifiedExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitQualifiedExpression(expression);
                KtExpression receiver = expression.getReceiverExpression();
                if (!(receiver instanceof KtStringTemplateExpression)) {
                    return;
                }
                String string = ((KtStringTemplateExpression)receiver).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                boolean isDollarString = StringsKt.startsWith$default((String)string, (String)"$$", (boolean)false, (int)2, null);
                KtExpression ktExpression = expression.getSelectorExpression();
                String string2 = ktExpression != null ? ktExpression.getText() : null;
                if (string2 == null) {
                    string2 = "";
                }
                String selectorExpression = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                boolean isTrimMargin = StringsKt.startsWith$default((String)selectorExpression, (String)"trimMargin()", (boolean)false, (int)2, null);
                boolean isTrimIndent = StringsKt.startsWith$default((String)selectorExpression, (String)"trimIndent()", (boolean)false, (int)2, null);
                if (isTrimIndent || isTrimMargin) {
                    void $this$getParentOfType$iv;
                    KtExpression ktExpression2 = expression.getSelectorExpression();
                    if (ktExpression2 == null) {
                        String string3 = "Required value was null.";
                        throw new IllegalStateException(string3.toString());
                    }
                    int trimOffset = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktExpression2)) - 1;
                    int stringOffset = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)receiver));
                    String string4 = this.$code.substring(0, stringOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    int lineStart = CollectionsKt.getLastIndex((List)StringsKt.lines((CharSequence)string4));
                    String string5 = this.$code.substring(0, trimOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    int lineEnd = CollectionsKt.getLastIndex((List)StringsKt.lines((CharSequence)string5));
                    String string6 = this.$code.substring(0, stringOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                    String it = StringsKt.substringBefore$default((String)((String)CollectionsKt.last((List)StringsKt.lines((CharSequence)string6))), (String)"\"\"\"", null, (int)2, null);
                    boolean bl = false;
                    int indentCount = it.length() - ((Object)StringsKt.trimStart((CharSequence)it)).toString().length();
                    PsiElement psiElement = (PsiElement)expression;
                    boolean strict$iv = false;
                    boolean $i$f$getParentOfType = false;
                    this.$strings.add(new MultilineTrimmedString(isTrimMargin, isDollarString, indentCount, StringsKt.lines((CharSequence)this.$code).subList(lineStart, lineEnd + 1), lineStart, lineEnd, stringOffset, trimOffset, PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtStringTemplateExpression.class, (boolean)strict$iv) != null));
                }
            }
        });
        return CollectionsKt.toList((Iterable)strings);
    }
}

