/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.auto.common.MoreElements;
import autovalue.shaded.com.google.common.base.VerifyException;
import autovalue.shaded.com.google.common.collect.ImmutableList;
import autovalue.shaded.com.google.common.collect.ImmutableSet;
import com.google.auto.value.processor.TypeEncoder;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

class Executable {
    private final ExecutableElement executableElement;
    private final ImmutableList<VariableElement> parameters;
    private final ImmutableSet<String> optionalParameters;
    private final ImmutableList<TypeParameterElement> typeParameters;

    private Executable(ExecutableElement executableElement, ImmutableSet<String> optionalParameters) {
        this.executableElement = executableElement;
        this.parameters = ImmutableList.copyOf(executableElement.getParameters());
        this.optionalParameters = optionalParameters;
        switch (executableElement.getKind()) {
            case CONSTRUCTOR: {
                TypeElement container = MoreElements.asType(executableElement.getEnclosingElement());
                this.typeParameters = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(container.getTypeParameters())).addAll(executableElement.getTypeParameters())).build();
                break;
            }
            case METHOD: {
                this.typeParameters = ImmutableList.copyOf(executableElement.getTypeParameters());
                break;
            }
            default: {
                throw new VerifyException("Unexpected executable kind " + (Object)((Object)executableElement.getKind()));
            }
        }
    }

    static Executable of(ExecutableElement executableElement) {
        return Executable.of(executableElement, ImmutableSet.of());
    }

    static Executable of(ExecutableElement executableElement, ImmutableSet<String> optionalParameters) {
        return new Executable(executableElement, optionalParameters);
    }

    ExecutableElement executableElement() {
        return this.executableElement;
    }

    ImmutableList<VariableElement> parameters() {
        return this.parameters;
    }

    ImmutableList<String> parameterNames() {
        return this.parameters.stream().map(v -> v.getSimpleName().toString()).collect(ImmutableList.toImmutableList());
    }

    boolean isOptional(String parameterName) {
        return this.optionalParameters.contains(parameterName);
    }

    boolean hasOptionalParameters() {
        return !this.optionalParameters.isEmpty();
    }

    ImmutableList<TypeParameterElement> typeParameters() {
        return this.typeParameters;
    }

    TypeMirror builtType() {
        switch (this.executableElement.getKind()) {
            case CONSTRUCTOR: {
                return this.executableElement.getEnclosingElement().asType();
            }
            case METHOD: {
                return this.executableElement.getReturnType();
            }
        }
        throw new VerifyException("Unexpected executable kind " + (Object)((Object)this.executableElement.getKind()));
    }

    String invoke() {
        TypeElement enclosing = MoreElements.asType(this.executableElement.getEnclosingElement());
        String type = TypeEncoder.encodeRaw(enclosing.asType());
        switch (this.executableElement.getKind()) {
            case CONSTRUCTOR: {
                boolean generic = !enclosing.getTypeParameters().isEmpty();
                String typeParams = generic ? "<>" : "";
                return "new " + type + typeParams;
            }
            case METHOD: {
                return type + "." + this.executableElement.getSimpleName();
            }
        }
        throw new VerifyException("Unexpected executable kind " + (Object)((Object)this.executableElement.getKind()));
    }

    public String toString() {
        ExecutableElement executable = this.executableElement;
        Element nameSource = executable.getKind() == ElementKind.CONSTRUCTOR ? executable.getEnclosingElement() : executable;
        return nameSource.getSimpleName() + executable.getParameters().stream().map(v -> v.asType() + " " + v.getSimpleName()).collect(Collectors.joining(", ", "(", ")"));
    }
}

