/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle.skaffold;

import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.plugins.common.SkaffoldInitOutput;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;

public class InitTask
extends DefaultTask {
    @Nullable
    private JibExtension jibExtension;

    public InitTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }

    @TaskAction
    public void listModulesAndTargets() throws IOException {
        Project project = this.getProject();
        if (!project.getSubprojects().isEmpty()) {
            return;
        }
        SkaffoldInitOutput skaffoldInitOutput = new SkaffoldInitOutput();
        skaffoldInitOutput.setImage(((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getTo().getImage());
        if (!project.equals(project.getRootProject())) {
            skaffoldInitOutput.setProject(project.getName());
        }
        System.out.println();
        System.out.println("BEGIN JIB JSON");
        System.out.println(skaffoldInitOutput.getJsonString());
    }
}

