/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonEncoding;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonFactory;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.MergedStream;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.UTF32Reader;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.ReaderBasedJsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.UTF8StreamJsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.VersionUtil;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public final class ByteSourceJsonBootstrapper {
    private final IOContext _context;
    private final InputStream _in;
    private final byte[] _inputBuffer;
    private int _inputPtr;
    private int _inputEnd;
    private final boolean _bufferRecyclable;
    private boolean _bigEndian = true;
    private int _bytesPerChar;

    public ByteSourceJsonBootstrapper(IOContext iOContext, InputStream inputStream) {
        this._context = iOContext;
        this._in = inputStream;
        this._inputBuffer = iOContext.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._bufferRecyclable = true;
    }

    public ByteSourceJsonBootstrapper(IOContext iOContext, byte[] byArray, int n2, int n3) {
        this._context = iOContext;
        this._in = null;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputEnd = n2 + n3;
        this._bufferRecyclable = false;
    }

    public JsonEncoding detectEncoding() throws IOException {
        JsonEncoding jsonEncoding;
        int n2;
        boolean bl2 = false;
        if (this.ensureLoaded(4)) {
            n2 = this._inputBuffer[this._inputPtr] << 24 | (this._inputBuffer[this._inputPtr + 1] & 0xFF) << 16 | (this._inputBuffer[this._inputPtr + 2] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 3] & 0xFF;
            if (this.handleBOM(n2)) {
                bl2 = true;
            } else if (this.checkUTF32(n2)) {
                bl2 = true;
            } else if (this.checkUTF16(n2 >>> 16)) {
                bl2 = true;
            }
        } else if (this.ensureLoaded(2) && this.checkUTF16(n2 = (this._inputBuffer[this._inputPtr] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 1] & 0xFF)) {
            bl2 = true;
        }
        if (!bl2) {
            jsonEncoding = JsonEncoding.UTF8;
        } else {
            switch (this._bytesPerChar) {
                case 1: {
                    jsonEncoding = JsonEncoding.UTF8;
                    break;
                }
                case 2: {
                    jsonEncoding = this._bigEndian ? JsonEncoding.UTF16_BE : JsonEncoding.UTF16_LE;
                    break;
                }
                case 4: {
                    jsonEncoding = this._bigEndian ? JsonEncoding.UTF32_BE : JsonEncoding.UTF32_LE;
                    break;
                }
                default: {
                    return (JsonEncoding)((Object)VersionUtil.throwInternalReturnAny());
                }
            }
        }
        this._context.setEncoding(jsonEncoding);
        return jsonEncoding;
    }

    public Reader constructReader() throws IOException {
        JsonEncoding jsonEncoding = this._context.getEncoding();
        switch (jsonEncoding.bits()) {
            case 8: 
            case 16: {
                InputStream inputStream = this._in;
                if (inputStream == null) {
                    int n2 = this._inputEnd - this._inputPtr;
                    if (n2 <= 8192) {
                        return new StringReader(new String(this._inputBuffer, this._inputPtr, n2, jsonEncoding.getJavaName()));
                    }
                    inputStream = new ByteArrayInputStream(this._inputBuffer, this._inputPtr, this._inputEnd);
                } else if (this._inputPtr < this._inputEnd) {
                    inputStream = new MergedStream(this._context, inputStream, this._inputBuffer, this._inputPtr, this._inputEnd);
                }
                return new InputStreamReader(inputStream, jsonEncoding.getJavaName());
            }
            case 32: {
                return new UTF32Reader(this._context, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._context.getEncoding().isBigEndian());
            }
        }
        return (Reader)VersionUtil.throwInternalReturnAny();
    }

    public JsonParser constructParser(int n2, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, CharsToNameCanonicalizer charsToNameCanonicalizer, int n3) throws IOException {
        int n4 = this._inputPtr;
        JsonEncoding jsonEncoding = JsonFactory.Feature.CHARSET_DETECTION.enabledIn(n3) ? this.detectEncoding() : JsonEncoding.UTF8;
        int n5 = this._inputPtr - n4;
        if (jsonEncoding == JsonEncoding.UTF8 && JsonFactory.Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n3)) {
            ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = byteQuadsCanonicalizer.makeChild(n3);
            return new UTF8StreamJsonParser(this._context, n2, this._in, objectCodec, byteQuadsCanonicalizer2, this._inputBuffer, this._inputPtr, this._inputEnd, n5, this._bufferRecyclable);
        }
        return new ReaderBasedJsonParser(this._context, n2, this.constructReader(), objectCodec, charsToNameCanonicalizer.makeChild());
    }

    private boolean handleBOM(int n2) throws IOException {
        switch (n2) {
            case 65279: {
                this._bigEndian = true;
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                return true;
            }
            case -131072: {
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                this._bigEndian = false;
                return true;
            }
            case 65534: {
                this.reportWeirdUCS4("2143");
                break;
            }
            case -16842752: {
                this.reportWeirdUCS4("3412");
                break;
            }
        }
        int n3 = n2 >>> 16;
        if (n3 == 65279) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = true;
            return true;
        }
        if (n3 == 65534) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = false;
            return true;
        }
        if (n2 >>> 8 == 0xEFBBBF) {
            this._inputPtr += 3;
            this._bytesPerChar = 1;
            this._bigEndian = true;
            return true;
        }
        return false;
    }

    private boolean checkUTF32(int n2) throws IOException {
        if (n2 >> 8 == 0) {
            this._bigEndian = true;
        } else if ((n2 & 0xFFFFFF) == 0) {
            this._bigEndian = false;
        } else if ((n2 & 0xFF00FFFF) == 0) {
            this.reportWeirdUCS4("3412");
        } else if ((n2 & 0xFFFF00FF) == 0) {
            this.reportWeirdUCS4("2143");
        } else {
            return false;
        }
        this._bytesPerChar = 4;
        return true;
    }

    private boolean checkUTF16(int n2) {
        if ((n2 & 0xFF00) == 0) {
            this._bigEndian = true;
        } else if ((n2 & 0xFF) == 0) {
            this._bigEndian = false;
        } else {
            return false;
        }
        this._bytesPerChar = 2;
        return true;
    }

    private void reportWeirdUCS4(String string) throws IOException {
        throw new CharConversionException("Unsupported UCS-4 endianness (" + string + ") detected");
    }

    protected boolean ensureLoaded(int n2) throws IOException {
        int n3;
        for (int i2 = this._inputEnd - this._inputPtr; i2 < n2; i2 += n3) {
            n3 = this._in == null ? -1 : this._in.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n3 < 1) {
                return false;
            }
            this._inputEnd += n3;
        }
        return true;
    }
}

