/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.gradleplugin.test;

import com.gradle.enterprise.gradleplugin.test.JUnitXmlDialect;
import com.gradle.junit.xml.streaming.parser.i;
import com.gradle.obfuscation.KeepMethods;
import com.gradle.obfuscation.KeepName;
import com.gradle.scan.plugin.internal.b.v.c;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeepName
@KeepMethods
public abstract class ImportJUnitXmlReports
extends DefaultTask {
    protected static final Logger a = LoggerFactory.getLogger(ImportJUnitXmlReports.class);
    private static final String b = "ImportJUnitXmlReports";
    private final BuildOperationListener c;
    private final CurrentBuildOperationRef d;
    private final Clock e;

    @Inject
    public ImportJUnitXmlReports(BuildOperationListenerManager listenerManager, CurrentBuildOperationRef currentOperation, Clock clock) {
        this.c = listenerManager.getBroadcaster();
        this.d = currentOperation;
        this.e = clock;
    }

    @Input
    public abstract Property<JUnitXmlDialect> getDialect();

    @Internal
    public abstract ConfigurableFileCollection getReports();

    @Internal
    public abstract Property<Task> getReferenceTask();

    @TaskAction
    void importReports() {
        if (!((Boolean)this.getReferenceTask().map(Task::getDidWork).getOrElse((Object)true)).booleanValue()) {
            this.setDidWork(false);
            return;
        }
        TaskInternal taskInternal = (TaskInternal)this.getReferenceTask().getOrElse((Object)this);
        TaskIdentity referenceTaskIdentity = taskInternal.getTaskIdentity();
        Set xmlFiles = this.getReports().filter(File::exists).filter(file -> file.getName().endsWith(".xml")).getFiles();
        if (xmlFiles.isEmpty()) {
            a.warn("No JUnit XML reports found in any of the declared inputs!");
        } else {
            i dialect = ((JUnitXmlDialect)((Object)this.getDialect().get())).toParserDialect();
            xmlFiles.stream().map(xml -> new a(xml.getAbsoluteFile(), referenceTaskIdentity, dialect)).forEach(this::emitEvent);
        }
    }

    private void emitEvent(c event) {
        this.c.progress(com.gradle.enterprise.a.a.a(this.d.getId(), () -> "operationIdentifier is null"), new OperationProgressEvent(this.e.getCurrentTime(), (Object)event));
    }

    public static TaskProvider<ImportJUnitXmlReports> register(TaskContainer tasks, TaskProvider<?> testTask, JUnitXmlDialect dialect) {
        TaskProvider<ImportJUnitXmlReports> finalizerTask = ImportJUnitXmlReports.registerFinalizerTask(tasks, testTask, dialect);
        testTask.configure(task -> task.finalizedBy(new Object[]{finalizerTask}));
        return finalizerTask;
    }

    private static TaskProvider<ImportJUnitXmlReports> registerFinalizerTask(TaskContainer tasks, TaskProvider<?> testTask, JUnitXmlDialect dialect) {
        return tasks.register(testTask.getName() + b, ImportJUnitXmlReports.class, importTask -> {
            importTask.getDialect().set((Object)dialect);
            importTask.getReferenceTask().set((Provider)testTask);
            importTask.getReports().from(new Object[]{testTask.map(task -> task.getOutputs().getFiles().getAsFileTree())});
        });
    }

    private static class a
    implements c {
        private final File a;
        private final TaskIdentity<?> b;
        private final i c;

        private a(File xmlFile, TaskIdentity<?> referenceTask, i dialect) {
            this.a = xmlFile;
            this.b = referenceTask;
            this.c = dialect;
        }

        @Override
        public File a() {
            return this.a;
        }

        @Override
        public TaskIdentity<?> b() {
            return this.b;
        }

        @Override
        public i c() {
            return this.c;
        }
    }
}

