package com.gradle.publish;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;

/**
 * Adapted from Adept Hasher with permission
 */
class Hasher {

    static final ThreadLocal<MessageDigest> md = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA-256");
        } catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    });

    static String hash(byte[] bytes) {
        MessageDigest currentMd = md.get();
        currentMd.reset();
        try {
            currentMd.update(bytes);
            return toHex(currentMd.digest()).toLowerCase();
        } finally {
            currentMd.reset();
        }
    }

    static String hash(InputStream is) throws IOException {
        MessageDigest currentMd = md.get();
        currentMd.reset();
        try {
            byte[] buf = new byte[1024 * 4]; // _seemed_ to be the fastest
            int len = is.read(buf);

            while (len > 0) {
                currentMd.update(buf, 0, len);
                len = is.read(buf);
            }
            return toHex(currentMd.digest()).toLowerCase();
        } finally {
            currentMd.reset();
        }
    }

    static String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        return String.format("%0" + (bytes.length << 1) + "X", bi);
    }
}
