package com.gradle.publish;

import org.gradle.plugin.devel.PluginDeclaration;

import java.util.ArrayList;
import java.util.List;

public class PluginConfiguration {
    final String name;
    final String id;
    final String displayName;
    final String description;
    final String implementationClass;
    final List<String> tags;

    public PluginConfiguration(
        String name,
        String id,
        String displayName,
        String description,
        String implementationClass,
        List<String> tags
    ) {
        this.name = name;
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.implementationClass = implementationClass;
        this.tags = tags;
    }

    public PluginConfiguration(PluginDeclaration plugin) {
        this(
            plugin.getName(),
            plugin.getId(),
            plugin.getDisplayName(),
            plugin.getDescription(),
            plugin.getImplementationClass(),
            new ArrayList<>(plugin.getTags().get())
        );
    }
}
