package com.gradle.publish;

import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;

import java.util.List;
import java.util.stream.Collectors;

public class PluginsConfigurations {
    final String website;
    final String vcsUrl;
    final List<PluginConfiguration> plugins;

    public PluginsConfigurations(
        String website,
        String vcsUrl,
        List<PluginConfiguration> plugins
    ) {
        this.website = website;
        this.vcsUrl = vcsUrl;
        this.plugins = plugins;
    }

    public PluginsConfigurations(GradlePluginDevelopmentExtension extension) {
        this(
            extension.getWebsite().getOrNull(),
            extension.getVcsUrl().getOrNull(),
            extension.getPlugins().stream().map(PluginConfiguration::new).collect(Collectors.toList())
        );
    }
}
