package com.gradle.publish;

import com.gradle.publish.util.LayoutPreservingProperties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

class PropertiesStore {

    static LayoutPreservingProperties fromFile(File file) throws IOException {
        LayoutPreservingProperties properties = new LayoutPreservingProperties();
        properties.setRemoveComments(true);
        if (file.exists()) {
            try (InputStream in = new FileInputStream(file)) {
                properties.load(in);
            }
        }
        return properties;
    }

    static void append(File propertiesFile, Map<String, String> props, String message) throws IOException {
        FileOutputStream out = null;
        try {
            LayoutPreservingProperties properties = fromFile(propertiesFile);
            out = new FileOutputStream(propertiesFile);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                properties.setProperty(entry.getKey(), entry.getValue());
            }
            properties.store(out, message);
        } finally {
            if (null != out) {
                out.close();
            }
        }
    }
}

