package com.gradle.publish;

import com.gradle.protocols.ServerResponseBase;
import com.gradle.publish.protocols.v1.models.ClientRequest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

final class ResponseUtil {

    private ResponseUtil() {
    }

    public static String readResponse(HttpURLConnection connection) throws IOException {
        return readResponse(connection.getInputStream());
    }

    public static String readResponse(InputStream is) throws IOException {
        try (InputStream input = is; ByteArrayOutputStream baos = new ByteArrayOutputStream()) {
            byte[] buffer = new byte[8192];
            int bytesRead;
            while ((bytesRead = input.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            return new String(baos.toByteArray(), StandardCharsets.UTF_8);
        }
    }

    public static <T extends ServerResponseBase> void assertValidResponse(String actionMsg, T apiResponse) {
        String errorMessage = "";
        if (apiResponse == null) {
            errorMessage += "Did not get a response from server";
            throw new RuntimeException(actionMsg + "\n" + errorMessage);
        } else if (apiResponse.hasFailed() && apiResponse.getErrorMessage() != null) {
            errorMessage += "Server responded with:\n" + apiResponse.getErrorMessage();
            throw new RuntimeException(actionMsg + "\n" + errorMessage);
        } else if (apiResponse.hasFailed()) {
            errorMessage += "Server did not specify reason";
            throw new RuntimeException(actionMsg + "\n" + errorMessage);
        }
    }

    public static <Resp, Req extends ClientRequest<Resp>> Resp convertResponse(
        Req request,
        URL url,
        String response,
        int statusCode
    ) {
        return convertResponse(request, url.toExternalForm(), response, statusCode);
    }

    public static <Resp, Req extends ClientRequest<Resp>> Resp convertResponse(
        Req request,
        String url,
        String response,
        int statusCode
    ) {
        try {
            return request.convertResponse(response);
        } catch (Exception e) {
            // probably wrong url
            throw new RuntimeException("Error communicating with server.\n"
                + "URL " + url + " returned response code " + statusCode);
        }
    }
}
