/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client;

import com.google.gson.JsonObject;
import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPRequest;
import com.mercadopago.net.MPResponse;
import com.mercadopago.net.MPSearchRequest;
import com.mercadopago.net.UrlFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class MercadoPagoClient {
    private static final String ACCEPT_HEADER_VALUE = "application/json";
    private static final String CONTENT_TYPE_HEADER_VALUE = "application/json; charset=UTF-8";
    private static final String BEARER = "Bearer %s";
    private static final String OAUTH_TOKEN = "/oauth/token";
    protected final MPHttpClient httpClient;
    protected Map<String, String> defaultHeaders;

    public MercadoPagoClient(MPHttpClient httpClient) {
        this.httpClient = httpClient;
        this.defaultHeaders = new HashMap<String, String>();
        this.defaultHeaders.put("Accept", ACCEPT_HEADER_VALUE);
        this.defaultHeaders.put("X-Product-Id", "BC32A7VTRPP001U8NHJ0");
        this.defaultHeaders.put("User-Agent", String.format("MercadoPago Java SDK/%s", "2.5.0"));
        this.defaultHeaders.put("X-Tracking-Id", MercadoPagoConfig.TRACKING_ID);
        this.defaultHeaders.put("Content-Type", CONTENT_TYPE_HEADER_VALUE);
    }

    protected MPResponse send(MPRequest request) throws MPException, MPApiException {
        return this.send(request, null);
    }

    protected MPResponse send(MPRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        String uri = UrlFormatter.format(request.getUri(), request.getQueryParams());
        return this.httpClient.send(MPRequest.builder().uri(uri).accessToken(this.getAccessToken(requestOptions)).method(request.getMethod()).headers(this.addRequestHeaders(request, requestOptions)).payload(request.getPayload()).connectionRequestTimeout(this.addConnectionRequestTimeout(request, requestOptions)).connectionTimeout(this.addConnectionTimeout(request, requestOptions)).socketTimeout(this.addSocketTimeout(request, requestOptions)).build());
    }

    protected MPResponse send(String path, HttpMethod method, JsonObject payload, Map<String, Object> queryParams) throws MPException, MPApiException {
        return this.send(path, method, payload, queryParams, null);
    }

    protected MPResponse send(String path, HttpMethod method, JsonObject payload, Map<String, Object> queryParams, MPRequestOptions requestOptions) throws MPException, MPApiException {
        MPRequest mpRequest = this.buildRequest(path, method, payload, queryParams, requestOptions);
        return this.send(mpRequest);
    }

    protected MPResponse search(String path, MPSearchRequest request) throws MPException, MPApiException {
        return this.search(path, request, null);
    }

    protected MPResponse search(String path, MPSearchRequest searchRequest, MPRequestOptions requestOptions) throws MPException, MPApiException {
        Map<String, Object> queryParams = Objects.nonNull(searchRequest) ? searchRequest.getParameters() : null;
        return this.send(path, HttpMethod.GET, null, queryParams, requestOptions);
    }

    protected MPResponse list(String path, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.list(path, HttpMethod.GET, null, null, requestOptions);
    }

    protected MPResponse list(String path, HttpMethod method, JsonObject payload, Map<String, Object> queryParams, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.send(path, method, payload, queryParams, requestOptions);
    }

    private MPRequest buildRequest(String path, HttpMethod method, JsonObject payload, Map<String, Object> queryParams, MPRequestOptions requestOptions) {
        return MPRequest.builder().uri(path).accessToken(this.getAccessToken(requestOptions)).payload(payload).method(method).queryParams(queryParams).headers(this.addCustomHeaders(path, requestOptions)).connectionRequestTimeout(this.addConnectionRequestTimeout(null, requestOptions)).connectionTimeout(this.addConnectionTimeout(null, requestOptions)).socketTimeout(this.addSocketTimeout(null, requestOptions)).build();
    }

    private int addSocketTimeout(MPRequest request, MPRequestOptions requestOptions) {
        if (Objects.nonNull(requestOptions) && requestOptions.getSocketTimeout() > 0) {
            return requestOptions.getSocketTimeout();
        }
        if (Objects.nonNull(request) && request.getSocketTimeout() > 0) {
            return request.getSocketTimeout();
        }
        return MercadoPagoConfig.getSocketTimeout();
    }

    private int addConnectionTimeout(MPRequest request, MPRequestOptions requestOptions) {
        if (Objects.nonNull(requestOptions) && requestOptions.getConnectionTimeout() > 0) {
            return requestOptions.getConnectionTimeout();
        }
        if (Objects.nonNull(request) && request.getConnectionTimeout() > 0) {
            return request.getConnectionTimeout();
        }
        return MercadoPagoConfig.getConnectionTimeout();
    }

    private int addConnectionRequestTimeout(MPRequest request, MPRequestOptions requestOptions) {
        if (Objects.nonNull(requestOptions) && requestOptions.getConnectionRequestTimeout() > 0) {
            return requestOptions.getConnectionRequestTimeout();
        }
        if (Objects.nonNull(request) && request.getConnectionRequestTimeout() > 0) {
            return request.getConnectionRequestTimeout();
        }
        return MercadoPagoConfig.getConnectionRequestTimeout();
    }

    private Map<String, String> addRequestHeaders(MPRequest request, MPRequestOptions requestOptions) {
        HashMap<String, String> headers = Objects.nonNull(request.getHeaders()) ? request.getHeaders() : new HashMap<String, String>();
        headers.putAll(this.addDefaultHeaders(request));
        if (StringUtils.isNotBlank((CharSequence)MercadoPagoConfig.getCorporationId())) {
            headers.put("X-Corporation-Id", MercadoPagoConfig.getCorporationId());
        }
        if (StringUtils.isNotBlank((CharSequence)MercadoPagoConfig.getIntegratorId())) {
            headers.put("X-Integrator-Id", MercadoPagoConfig.getIntegratorId());
        }
        if (StringUtils.isNotBlank((CharSequence)MercadoPagoConfig.getPlatformId())) {
            headers.put("X-Platform-Id", MercadoPagoConfig.getPlatformId());
        }
        if (Objects.nonNull(requestOptions) && MapUtils.isNotEmpty(requestOptions.getCustomHeaders())) {
            for (Map.Entry<String, String> header : requestOptions.getCustomHeaders().entrySet()) {
                if (headers.containsKey(header.getKey()) || "Content-Type".equalsIgnoreCase(header.getKey())) continue;
                headers.put(header.getKey().toLowerCase(), header.getValue());
            }
        }
        headers.putAll(this.addCustomHeaders(request.getUri(), requestOptions));
        return headers;
    }

    private Map<String, String> addDefaultHeaders(MPRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>(this.defaultHeaders);
        if (this.shouldAddIdempotencyKey(request)) {
            headers.put("X-Idempotency-Key", request.createIdempotencyKey());
        }
        if (Objects.nonNull(request) && !request.getUri().contains(OAUTH_TOKEN) && !headers.containsKey("Authorization")) {
            headers.put("Authorization", String.format(BEARER, this.chooseAccessToken(request)));
        }
        return headers;
    }

    private String chooseAccessToken(MPRequest request) {
        return request.getAccessToken() != null ? request.getAccessToken() : MercadoPagoConfig.getAccessToken();
    }

    private Map<String, String> addCustomHeaders(String uri, MPRequestOptions requestOptions) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (Objects.nonNull(requestOptions) && Objects.nonNull(requestOptions.getCustomHeaders())) {
            for (Map.Entry<String, String> entry : requestOptions.getCustomHeaders().entrySet()) {
                headers.put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }
        if (requestOptions != null && !uri.contains(OAUTH_TOKEN)) {
            headers.put("Authorization", String.format(BEARER, this.getAccessToken(requestOptions)));
        }
        return headers;
    }

    private boolean shouldAddIdempotencyKey(MPRequest request) {
        boolean containsIdempotency = false;
        if (Objects.nonNull(request) && Objects.nonNull(request.getHeaders())) {
            containsIdempotency = request.getHeaders().containsKey("X-Idempotency-Key".toLowerCase());
        }
        if (containsIdempotency) {
            return false;
        }
        return request.getMethod() == HttpMethod.POST || request.getMethod() == HttpMethod.PUT || request.getMethod() == HttpMethod.PATCH;
    }

    private String getAccessToken(MPRequestOptions requestOptions) {
        return Objects.nonNull(requestOptions) && Objects.nonNull(requestOptions.getAccessToken()) && !requestOptions.getAccessToken().isEmpty() ? requestOptions.getAccessToken() : MercadoPagoConfig.getAccessToken();
    }
}

