/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.customer;

import com.mercadopago.resources.customer.CustomerCardIssuer;

public class CustomerCardCreateRequest {
    private final String token;
    private final CustomerCardIssuer issuer;
    private final String paymentMethodId;

    CustomerCardCreateRequest(String token, CustomerCardIssuer issuer, String paymentMethodId) {
        this.token = token;
        this.issuer = issuer;
        this.paymentMethodId = paymentMethodId;
    }

    public static CustomerCardCreateRequestBuilder builder() {
        return new CustomerCardCreateRequestBuilder();
    }

    public String getToken() {
        return this.token;
    }

    public CustomerCardIssuer getIssuer() {
        return this.issuer;
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public static class CustomerCardCreateRequestBuilder {
        private String token;
        private CustomerCardIssuer issuer;
        private String paymentMethodId;

        CustomerCardCreateRequestBuilder() {
        }

        public CustomerCardCreateRequestBuilder token(String token) {
            this.token = token;
            return this;
        }

        public CustomerCardCreateRequestBuilder issuer(CustomerCardIssuer issuer) {
            this.issuer = issuer;
            return this;
        }

        public CustomerCardCreateRequestBuilder paymentMethodId(String paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
            return this;
        }

        public CustomerCardCreateRequest build() {
            return new CustomerCardCreateRequest(this.token, this.issuer, this.paymentMethodId);
        }

        public String toString() {
            return "CustomerCardCreateRequest.CustomerCardCreateRequestBuilder(token=" + this.token + ", issuer=" + this.issuer + ", paymentMethodId=" + this.paymentMethodId + ")";
        }
    }
}

