/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.customer;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.client.MercadoPagoClient;
import com.mercadopago.client.customer.CustomerCardClient;
import com.mercadopago.client.customer.CustomerCardCreateRequest;
import com.mercadopago.client.customer.CustomerRequest;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPRequest;
import com.mercadopago.net.MPResourceList;
import com.mercadopago.net.MPResponse;
import com.mercadopago.net.MPResultsResourcesPage;
import com.mercadopago.net.MPSearchRequest;
import com.mercadopago.resources.customer.Customer;
import com.mercadopago.resources.customer.CustomerCard;
import com.mercadopago.serialization.Serializer;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class CustomerClient
extends MercadoPagoClient {
    private static final Logger LOGGER = Logger.getLogger(CustomerClient.class.getName());
    private final CustomerCardClient cardClient;

    public CustomerClient() {
        this(MercadoPagoConfig.getHttpClient());
    }

    public CustomerClient(MPHttpClient httpClient) {
        super(httpClient);
        this.cardClient = new CustomerCardClient(httpClient);
        StreamHandler streamHandler = MercadoPagoConfig.getStreamHandler();
        streamHandler.setLevel(MercadoPagoConfig.getLoggingLevel());
        LOGGER.addHandler(streamHandler);
        LOGGER.setLevel(MercadoPagoConfig.getLoggingLevel());
    }

    public Customer get(String customerId) throws MPException, MPApiException {
        return this.get(customerId, null);
    }

    public Customer get(String customerId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending get customer request");
        MPResponse response = this.send(String.format("/v1/customers/%s", customerId), HttpMethod.GET, null, null, requestOptions);
        Customer customer = Serializer.deserializeFromJson(Customer.class, response.getContent());
        customer.setResponse(response);
        return customer;
    }

    public Customer create(CustomerRequest request) throws MPException, MPApiException {
        return this.create(request, null);
    }

    public Customer create(CustomerRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending create customer request");
        JsonObject payload = Serializer.serializeToJson(request);
        MPRequest mpRequest = MPRequest.buildRequest("/v1/customers", HttpMethod.POST, payload, null, requestOptions);
        MPResponse response = this.send(mpRequest);
        Customer customer = Serializer.deserializeFromJson(Customer.class, response.getContent());
        customer.setResponse(response);
        return customer;
    }

    public Customer update(String customerId, CustomerRequest request) throws MPException, MPApiException {
        return this.update(customerId, request, null);
    }

    public Customer update(String customerId, CustomerRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending update customer request");
        JsonObject payload = Serializer.serializeToJson(request);
        MPRequest mpRequest = MPRequest.buildRequest(String.format("/v1/customers/%s", customerId), HttpMethod.PUT, payload, null, requestOptions);
        MPResponse response = this.send(mpRequest);
        Customer customer = Serializer.deserializeFromJson(Customer.class, response.getContent());
        customer.setResponse(response);
        return customer;
    }

    public Customer delete(String customerId) throws MPException, MPApiException {
        return this.delete(customerId, null);
    }

    public Customer delete(String customerId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending delete customer request");
        MPRequest mpRequest = MPRequest.buildRequest(String.format("/v1/customers/%s", customerId), HttpMethod.DELETE, null, null, requestOptions);
        MPResponse response = this.send(mpRequest);
        Customer customer = Serializer.deserializeFromJson(Customer.class, response.getContent());
        customer.setResponse(response);
        return customer;
    }

    public MPResultsResourcesPage<Customer> search(MPSearchRequest request) throws MPException, MPApiException {
        return this.search(request, null);
    }

    public MPResultsResourcesPage<Customer> search(MPSearchRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending search customer request");
        MPResponse response = this.search("/v1/customers/search", request, requestOptions);
        Type responseType = new TypeToken<MPResultsResourcesPage<Customer>>(){}.getType();
        MPResultsResourcesPage<Customer> result = Serializer.deserializeResultsResourcesPageFromJson(responseType, response.getContent());
        result.setResponse(response);
        return result;
    }

    public CustomerCard getCard(String customerId, String cardId) throws MPException, MPApiException {
        return this.getCard(customerId, cardId, null);
    }

    public CustomerCard getCard(String customerId, String cardId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.cardClient.get(customerId, cardId, requestOptions);
    }

    public CustomerCard createCard(String customerId, CustomerCardCreateRequest request) throws MPException, MPApiException {
        return this.createCard(customerId, request, null);
    }

    public CustomerCard createCard(String customerId, CustomerCardCreateRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.cardClient.create(customerId, request, requestOptions);
    }

    public CustomerCard deleteCard(String customerId, String cardId) throws MPException, MPApiException {
        return this.deleteCard(customerId, cardId, null);
    }

    public CustomerCard deleteCard(String customerId, String cardId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.cardClient.delete(customerId, cardId, requestOptions);
    }

    public MPResourceList<CustomerCard> listCards(String customerId) throws MPException, MPApiException {
        return this.listCards(customerId, null);
    }

    public MPResourceList<CustomerCard> listCards(String customerId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.cardClient.listAll(customerId, requestOptions);
    }
}

