/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.merchantorder;

import java.math.BigDecimal;

public class MerchantOrderItemRequest {
    private final String id;
    private final String title;
    private final String description;
    private final String pictureUrl;
    private final String categoryId;
    private final int quantity;
    private final BigDecimal unitPrice;
    private final String currencyId;

    MerchantOrderItemRequest(String id, String title, String description, String pictureUrl, String categoryId, int quantity, BigDecimal unitPrice, String currencyId) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.pictureUrl = pictureUrl;
        this.categoryId = categoryId;
        this.quantity = quantity;
        this.unitPrice = unitPrice;
        this.currencyId = currencyId;
    }

    public static MerchantOrderItemRequestBuilder builder() {
        return new MerchantOrderItemRequestBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public static class MerchantOrderItemRequestBuilder {
        private String id;
        private String title;
        private String description;
        private String pictureUrl;
        private String categoryId;
        private int quantity;
        private BigDecimal unitPrice;
        private String currencyId;

        MerchantOrderItemRequestBuilder() {
        }

        public MerchantOrderItemRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        public MerchantOrderItemRequestBuilder title(String title) {
            this.title = title;
            return this;
        }

        public MerchantOrderItemRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public MerchantOrderItemRequestBuilder pictureUrl(String pictureUrl) {
            this.pictureUrl = pictureUrl;
            return this;
        }

        public MerchantOrderItemRequestBuilder categoryId(String categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public MerchantOrderItemRequestBuilder quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        public MerchantOrderItemRequestBuilder unitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        public MerchantOrderItemRequestBuilder currencyId(String currencyId) {
            this.currencyId = currencyId;
            return this;
        }

        public MerchantOrderItemRequest build() {
            return new MerchantOrderItemRequest(this.id, this.title, this.description, this.pictureUrl, this.categoryId, this.quantity, this.unitPrice, this.currencyId);
        }

        public String toString() {
            return "MerchantOrderItemRequest.MerchantOrderItemRequestBuilder(id=" + this.id + ", title=" + this.title + ", description=" + this.description + ", pictureUrl=" + this.pictureUrl + ", categoryId=" + this.categoryId + ", quantity=" + this.quantity + ", unitPrice=" + this.unitPrice + ", currencyId=" + this.currencyId + ")";
        }
    }
}

