/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.oauth;

public class CreateOauthCredentialRequest {
    private final String grantType = "authorization_code";
    private final String clientSecret;
    private final String clientId;
    private final String code;
    private final String redirectUri;

    CreateOauthCredentialRequest(String clientSecret, String clientId, String code, String redirectUri) {
        this.clientSecret = clientSecret;
        this.clientId = clientId;
        this.code = code;
        this.redirectUri = redirectUri;
    }

    public static CreateOauthCredentialRequestBuilder builder() {
        return new CreateOauthCredentialRequestBuilder();
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getCode() {
        return this.code;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public static class CreateOauthCredentialRequestBuilder {
        private String clientSecret;
        private String clientId;
        private String code;
        private String redirectUri;

        CreateOauthCredentialRequestBuilder() {
        }

        public CreateOauthCredentialRequestBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public CreateOauthCredentialRequestBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public CreateOauthCredentialRequestBuilder code(String code) {
            this.code = code;
            return this;
        }

        public CreateOauthCredentialRequestBuilder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public CreateOauthCredentialRequest build() {
            return new CreateOauthCredentialRequest(this.clientSecret, this.clientId, this.code, this.redirectUri);
        }

        public String toString() {
            return "CreateOauthCredentialRequest.CreateOauthCredentialRequestBuilder(clientSecret=" + this.clientSecret + ", clientId=" + this.clientId + ", code=" + this.code + ", redirectUri=" + this.redirectUri + ")";
        }
    }
}

