/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.order;

import com.google.gson.JsonObject;
import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.client.MercadoPagoClient;
import com.mercadopago.client.order.OrderCreateRequest;
import com.mercadopago.client.order.OrderPaymentRequest;
import com.mercadopago.client.order.OrderRefundRequest;
import com.mercadopago.client.order.OrderTransactionRequest;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPRequest;
import com.mercadopago.net.MPResponse;
import com.mercadopago.resources.order.Order;
import com.mercadopago.resources.order.OrderTransaction;
import com.mercadopago.resources.order.UpdateOrderTransaction;
import com.mercadopago.serialization.Serializer;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.apache.commons.lang.StringUtils;

public class OrderClient
extends MercadoPagoClient {
    private static final Logger LOGGER = Logger.getLogger(OrderClient.class.getName());
    private static final String URL_WITH_ID = "/v1/orders/%s";
    private static final String URL_PROCESS = "/v1/orders/%s/process";
    private static final String URL_TRANSACTION = "/v1/orders/%s/transactions";
    private static final String URL_CANCEL = "/v1/orders/%s/cancel";
    private static final String URL_CAPTURE = "/v1/orders/%s/capture";
    private static final String URL_REFUND = "/v1/orders/%s/refund";
    private static final String URL_TRANSACTION_WITH_ID = "/v1/orders/%s/transactions/%s";

    public OrderClient() {
        this(MercadoPagoConfig.getHttpClient());
    }

    public OrderClient(MPHttpClient httpClient) {
        super(httpClient);
        StreamHandler streamHandler = MercadoPagoConfig.getStreamHandler();
        streamHandler.setLevel(MercadoPagoConfig.getLoggingLevel());
        LOGGER.addHandler(streamHandler);
        LOGGER.setLevel(MercadoPagoConfig.getLoggingLevel());
    }

    public Order create(OrderCreateRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending order creation request");
        MPRequest mpRequest = MPRequest.builder().uri("/v1/orders").method(HttpMethod.POST).payload(Serializer.serializeToJson(request)).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        Order result = Serializer.deserializeFromJson(Order.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public Order create(OrderCreateRequest request) throws MPException, MPApiException {
        return this.create(request, null);
    }

    public Order get(String id) throws MPException, MPApiException {
        return this.get(id, null);
    }

    public Order get(String id, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending order get request");
        this.validateOrderID(id);
        String url = String.format(URL_WITH_ID, id);
        MPResponse response = this.send(url, HttpMethod.GET, null, null, requestOptions);
        Order order = Serializer.deserializeFromJson(Order.class, response.getContent());
        order.setResponse(response);
        return order;
    }

    public Order process(String id) throws MPException, MPApiException {
        return this.process(id, null);
    }

    public Order process(String id, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending order process request");
        this.validateOrderID(id);
        String url = String.format(URL_PROCESS, id);
        MPResponse response = this.send(url, HttpMethod.POST, null, null, requestOptions);
        Order order = Serializer.deserializeFromJson(Order.class, response.getContent());
        order.setResponse(response);
        return order;
    }

    public OrderTransaction createTransaction(String orderId, OrderTransactionRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending order transaction intent request");
        MPRequest mpRequest = MPRequest.builder().uri(String.format(URL_TRANSACTION, orderId)).method(HttpMethod.POST).payload(Serializer.serializeToJson(request)).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        OrderTransaction order = Serializer.deserializeFromJson(OrderTransaction.class, response.getContent());
        order.setResponse(response);
        return order;
    }

    public OrderTransaction createTransaction(String orderId, OrderTransactionRequest request) throws MPException, MPApiException {
        return this.createTransaction(orderId, request, null);
    }

    public UpdateOrderTransaction updateTransaction(String orderId, String transactionId, OrderPaymentRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending order transaction update request");
        this.validateOrderID(orderId);
        this.validateTransactionID(transactionId);
        String url = String.format(URL_TRANSACTION_WITH_ID, orderId, transactionId);
        LOGGER.fine("Update transaction URL: " + url);
        MPRequest mpRequest = MPRequest.builder().uri(url).method(HttpMethod.PUT).payload(Serializer.serializeToJson(request)).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        UpdateOrderTransaction order = Serializer.deserializeFromJson(UpdateOrderTransaction.class, response.getContent());
        order.setResponse(response);
        return order;
    }

    public UpdateOrderTransaction updateTransaction(String orderId, String transactionId, OrderPaymentRequest request) throws MPException, MPApiException {
        return this.updateTransaction(orderId, transactionId, request, null);
    }

    public Order cancel(String orderId) throws MPException, MPApiException {
        return this.cancel(orderId, null);
    }

    public Order cancel(String orderId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending order to delete");
        this.validateOrderID(orderId);
        String url = String.format(URL_CANCEL, orderId);
        MPResponse response = this.send(url, HttpMethod.POST, null, null, requestOptions);
        Order order = Serializer.deserializeFromJson(Order.class, response.getContent());
        order.setResponse(response);
        return order;
    }

    public Order capture(String orderId) throws MPException, MPApiException {
        return this.capture(orderId, null);
    }

    public Order capture(String orderId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending order to capture");
        this.validateOrderID(orderId);
        String url = String.format(URL_CAPTURE, orderId);
        MPResponse response = this.send(url, HttpMethod.POST, null, null, requestOptions);
        Order order = Serializer.deserializeFromJson(Order.class, response.getContent());
        order.setResponse(response);
        return order;
    }

    public OrderTransaction deleteTransaction(String orderId, String transactionId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending order transaction delete request");
        this.validateOrderID(orderId);
        this.validateTransactionID(transactionId);
        String url = String.format(URL_TRANSACTION_WITH_ID, orderId, transactionId);
        LOGGER.fine("Delete transaction URL: " + url);
        MPResponse response = this.send(url, HttpMethod.DELETE, null, null, requestOptions);
        OrderTransaction order = new OrderTransaction();
        order.setResponse(response);
        return order;
    }

    public OrderTransaction deleteTransaction(String orderId, String transactionId) throws MPException, MPApiException {
        return this.deleteTransaction(orderId, transactionId, null);
    }

    public Order refund(String orderId) throws MPException, MPApiException {
        return this.refund(orderId, null, null);
    }

    public Order refund(String orderId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.refund(orderId, null, requestOptions);
    }

    public Order refund(String orderId, OrderRefundRequest request) throws MPException, MPApiException {
        return this.refund(orderId, request, null);
    }

    public Order refund(String orderId, OrderRefundRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending order transaction intent request");
        this.validateOrderID(orderId);
        JsonObject payload = request != null ? Serializer.serializeToJson(request) : null;
        MPRequest mpRequest = MPRequest.builder().uri(String.format(URL_REFUND, orderId)).method(HttpMethod.POST).payload(payload).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        Order order = Serializer.deserializeFromJson(Order.class, response.getContent());
        order.setResponse(response);
        return order;
    }

    void validateOrderID(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Order id cannot be null or empty");
        }
    }

    void validateTransactionID(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Transaction id cannot be null or empty");
        }
    }
}

