/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.order;

import com.mercadopago.client.order.OrderOnlineConfig;
import com.mercadopago.client.order.OrderPaymentMethodConfig;

public class OrderConfigRequest {
    private OrderPaymentMethodConfig paymentMethod;
    private OrderOnlineConfig online;

    OrderConfigRequest(OrderPaymentMethodConfig paymentMethod, OrderOnlineConfig online) {
        this.paymentMethod = paymentMethod;
        this.online = online;
    }

    public static OrderConfigRequestBuilder builder() {
        return new OrderConfigRequestBuilder();
    }

    public OrderPaymentMethodConfig getPaymentMethod() {
        return this.paymentMethod;
    }

    public OrderOnlineConfig getOnline() {
        return this.online;
    }

    public static class OrderConfigRequestBuilder {
        private OrderPaymentMethodConfig paymentMethod;
        private OrderOnlineConfig online;

        OrderConfigRequestBuilder() {
        }

        public OrderConfigRequestBuilder paymentMethod(OrderPaymentMethodConfig paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public OrderConfigRequestBuilder online(OrderOnlineConfig online) {
            this.online = online;
            return this;
        }

        public OrderConfigRequest build() {
            return new OrderConfigRequest(this.paymentMethod, this.online);
        }

        public String toString() {
            return "OrderConfigRequest.OrderConfigRequestBuilder(paymentMethod=" + this.paymentMethod + ", online=" + this.online + ")";
        }
    }
}

