/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.order;

import com.mercadopago.client.order.OrderDifferentialPricing;

public class OrderOnlineConfig {
    private String callbackUrl;
    private String successUrl;
    private String pendingUrl;
    private String failureUrl;
    private String autoReturnUrl;
    private OrderDifferentialPricing differentialPricing;

    OrderOnlineConfig(String callbackUrl, String successUrl, String pendingUrl, String failureUrl, String autoReturnUrl, OrderDifferentialPricing differentialPricing) {
        this.callbackUrl = callbackUrl;
        this.successUrl = successUrl;
        this.pendingUrl = pendingUrl;
        this.failureUrl = failureUrl;
        this.autoReturnUrl = autoReturnUrl;
        this.differentialPricing = differentialPricing;
    }

    public static OrderOnlineConfigBuilder builder() {
        return new OrderOnlineConfigBuilder();
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getSuccessUrl() {
        return this.successUrl;
    }

    public String getPendingUrl() {
        return this.pendingUrl;
    }

    public String getFailureUrl() {
        return this.failureUrl;
    }

    public String getAutoReturnUrl() {
        return this.autoReturnUrl;
    }

    public OrderDifferentialPricing getDifferentialPricing() {
        return this.differentialPricing;
    }

    public static class OrderOnlineConfigBuilder {
        private String callbackUrl;
        private String successUrl;
        private String pendingUrl;
        private String failureUrl;
        private String autoReturnUrl;
        private OrderDifferentialPricing differentialPricing;

        OrderOnlineConfigBuilder() {
        }

        public OrderOnlineConfigBuilder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public OrderOnlineConfigBuilder successUrl(String successUrl) {
            this.successUrl = successUrl;
            return this;
        }

        public OrderOnlineConfigBuilder pendingUrl(String pendingUrl) {
            this.pendingUrl = pendingUrl;
            return this;
        }

        public OrderOnlineConfigBuilder failureUrl(String failureUrl) {
            this.failureUrl = failureUrl;
            return this;
        }

        public OrderOnlineConfigBuilder autoReturnUrl(String autoReturnUrl) {
            this.autoReturnUrl = autoReturnUrl;
            return this;
        }

        public OrderOnlineConfigBuilder differentialPricing(OrderDifferentialPricing differentialPricing) {
            this.differentialPricing = differentialPricing;
            return this;
        }

        public OrderOnlineConfig build() {
            return new OrderOnlineConfig(this.callbackUrl, this.successUrl, this.pendingUrl, this.failureUrl, this.autoReturnUrl, this.differentialPricing);
        }

        public String toString() {
            return "OrderOnlineConfig.OrderOnlineConfigBuilder(callbackUrl=" + this.callbackUrl + ", successUrl=" + this.successUrl + ", pendingUrl=" + this.pendingUrl + ", failureUrl=" + this.failureUrl + ", autoReturnUrl=" + this.autoReturnUrl + ", differentialPricing=" + this.differentialPricing + ")";
        }
    }
}

