/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.order;

import com.mercadopago.client.order.OrderPayerAddressRequest;
import com.mercadopago.resources.common.Identification;
import com.mercadopago.resources.common.Phone;

public class OrderPayerRequest {
    private String entityType;
    private String email;
    private String firstName;
    private String customerId;
    private String lastName;
    private Identification identification;
    private Phone phone;
    private OrderPayerAddressRequest address;

    OrderPayerRequest(String entityType, String email, String firstName, String customerId, String lastName, Identification identification, Phone phone, OrderPayerAddressRequest address) {
        this.entityType = entityType;
        this.email = email;
        this.firstName = firstName;
        this.customerId = customerId;
        this.lastName = lastName;
        this.identification = identification;
        this.phone = phone;
        this.address = address;
    }

    public static OrderPayerRequestBuilder builder() {
        return new OrderPayerRequestBuilder();
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Identification getIdentification() {
        return this.identification;
    }

    public Phone getPhone() {
        return this.phone;
    }

    public OrderPayerAddressRequest getAddress() {
        return this.address;
    }

    public static class OrderPayerRequestBuilder {
        private String entityType;
        private String email;
        private String firstName;
        private String customerId;
        private String lastName;
        private Identification identification;
        private Phone phone;
        private OrderPayerAddressRequest address;

        OrderPayerRequestBuilder() {
        }

        public OrderPayerRequestBuilder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public OrderPayerRequestBuilder email(String email) {
            this.email = email;
            return this;
        }

        public OrderPayerRequestBuilder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public OrderPayerRequestBuilder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public OrderPayerRequestBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public OrderPayerRequestBuilder identification(Identification identification) {
            this.identification = identification;
            return this;
        }

        public OrderPayerRequestBuilder phone(Phone phone) {
            this.phone = phone;
            return this;
        }

        public OrderPayerRequestBuilder address(OrderPayerAddressRequest address) {
            this.address = address;
            return this;
        }

        public OrderPayerRequest build() {
            return new OrderPayerRequest(this.entityType, this.email, this.firstName, this.customerId, this.lastName, this.identification, this.phone, this.address);
        }

        public String toString() {
            return "OrderPayerRequest.OrderPayerRequestBuilder(entityType=" + this.entityType + ", email=" + this.email + ", firstName=" + this.firstName + ", customerId=" + this.customerId + ", lastName=" + this.lastName + ", identification=" + this.identification + ", phone=" + this.phone + ", address=" + this.address + ")";
        }
    }
}

