/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.order;

import com.mercadopago.client.order.OrderAutomaticPaymentsRequest;
import com.mercadopago.client.order.OrderPaymentMethodRequest;
import com.mercadopago.client.order.OrderStoredCredentialRequest;
import com.mercadopago.client.order.OrderSubscriptionDataRequest;

public class OrderPaymentRequest {
    private String amount;
    private String expirationTime;
    private OrderPaymentMethodRequest paymentMethod;
    private OrderAutomaticPaymentsRequest automaticPayments;
    private OrderStoredCredentialRequest storedCredential;
    private OrderSubscriptionDataRequest subscriptionData;

    OrderPaymentRequest(String amount, String expirationTime, OrderPaymentMethodRequest paymentMethod, OrderAutomaticPaymentsRequest automaticPayments, OrderStoredCredentialRequest storedCredential, OrderSubscriptionDataRequest subscriptionData) {
        this.amount = amount;
        this.expirationTime = expirationTime;
        this.paymentMethod = paymentMethod;
        this.automaticPayments = automaticPayments;
        this.storedCredential = storedCredential;
        this.subscriptionData = subscriptionData;
    }

    public static OrderPaymentRequestBuilder builder() {
        return new OrderPaymentRequestBuilder();
    }

    public String getAmount() {
        return this.amount;
    }

    public String getExpirationTime() {
        return this.expirationTime;
    }

    public OrderPaymentMethodRequest getPaymentMethod() {
        return this.paymentMethod;
    }

    public OrderAutomaticPaymentsRequest getAutomaticPayments() {
        return this.automaticPayments;
    }

    public OrderStoredCredentialRequest getStoredCredential() {
        return this.storedCredential;
    }

    public OrderSubscriptionDataRequest getSubscriptionData() {
        return this.subscriptionData;
    }

    public static class OrderPaymentRequestBuilder {
        private String amount;
        private String expirationTime;
        private OrderPaymentMethodRequest paymentMethod;
        private OrderAutomaticPaymentsRequest automaticPayments;
        private OrderStoredCredentialRequest storedCredential;
        private OrderSubscriptionDataRequest subscriptionData;

        OrderPaymentRequestBuilder() {
        }

        public OrderPaymentRequestBuilder amount(String amount) {
            this.amount = amount;
            return this;
        }

        public OrderPaymentRequestBuilder expirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public OrderPaymentRequestBuilder paymentMethod(OrderPaymentMethodRequest paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public OrderPaymentRequestBuilder automaticPayments(OrderAutomaticPaymentsRequest automaticPayments) {
            this.automaticPayments = automaticPayments;
            return this;
        }

        public OrderPaymentRequestBuilder storedCredential(OrderStoredCredentialRequest storedCredential) {
            this.storedCredential = storedCredential;
            return this;
        }

        public OrderPaymentRequestBuilder subscriptionData(OrderSubscriptionDataRequest subscriptionData) {
            this.subscriptionData = subscriptionData;
            return this;
        }

        public OrderPaymentRequest build() {
            return new OrderPaymentRequest(this.amount, this.expirationTime, this.paymentMethod, this.automaticPayments, this.storedCredential, this.subscriptionData);
        }

        public String toString() {
            return "OrderPaymentRequest.OrderPaymentRequestBuilder(amount=" + this.amount + ", expirationTime=" + this.expirationTime + ", paymentMethod=" + this.paymentMethod + ", automaticPayments=" + this.automaticPayments + ", storedCredential=" + this.storedCredential + ", subscriptionData=" + this.subscriptionData + ")";
        }
    }
}

