/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.order;

public class OrderStoredCredentialRequest {
    private String paymentInitiator;
    private String reason;
    private Boolean storePaymentMethod;
    private Boolean firstPayment;

    OrderStoredCredentialRequest(String paymentInitiator, String reason, Boolean storePaymentMethod, Boolean firstPayment) {
        this.paymentInitiator = paymentInitiator;
        this.reason = reason;
        this.storePaymentMethod = storePaymentMethod;
        this.firstPayment = firstPayment;
    }

    public static OrderStoredCredentialRequestBuilder builder() {
        return new OrderStoredCredentialRequestBuilder();
    }

    public String getPaymentInitiator() {
        return this.paymentInitiator;
    }

    public String getReason() {
        return this.reason;
    }

    public Boolean getStorePaymentMethod() {
        return this.storePaymentMethod;
    }

    public Boolean getFirstPayment() {
        return this.firstPayment;
    }

    public static class OrderStoredCredentialRequestBuilder {
        private String paymentInitiator;
        private String reason;
        private Boolean storePaymentMethod;
        private Boolean firstPayment;

        OrderStoredCredentialRequestBuilder() {
        }

        public OrderStoredCredentialRequestBuilder paymentInitiator(String paymentInitiator) {
            this.paymentInitiator = paymentInitiator;
            return this;
        }

        public OrderStoredCredentialRequestBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public OrderStoredCredentialRequestBuilder storePaymentMethod(Boolean storePaymentMethod) {
            this.storePaymentMethod = storePaymentMethod;
            return this;
        }

        public OrderStoredCredentialRequestBuilder firstPayment(Boolean firstPayment) {
            this.firstPayment = firstPayment;
            return this;
        }

        public OrderStoredCredentialRequest build() {
            return new OrderStoredCredentialRequest(this.paymentInitiator, this.reason, this.storePaymentMethod, this.firstPayment);
        }

        public String toString() {
            return "OrderStoredCredentialRequest.OrderStoredCredentialRequestBuilder(paymentInitiator=" + this.paymentInitiator + ", reason=" + this.reason + ", storePaymentMethod=" + this.storePaymentMethod + ", firstPayment=" + this.firstPayment + ")";
        }
    }
}

