/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

import com.google.gson.reflect.TypeToken;
import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.client.MercadoPagoClient;
import com.mercadopago.client.payment.PaymentCancelRequest;
import com.mercadopago.client.payment.PaymentCaptureRequest;
import com.mercadopago.client.payment.PaymentCreateRequest;
import com.mercadopago.client.payment.PaymentRefundClient;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPRequest;
import com.mercadopago.net.MPResourceList;
import com.mercadopago.net.MPResponse;
import com.mercadopago.net.MPResultsResourcesPage;
import com.mercadopago.net.MPSearchRequest;
import com.mercadopago.resources.payment.Payment;
import com.mercadopago.resources.payment.PaymentRefund;
import com.mercadopago.serialization.Serializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class PaymentClient
extends MercadoPagoClient {
    private static final Logger LOGGER = Logger.getLogger(PaymentClient.class.getName());
    private static final String URL_WITH_ID = "/v1/payments/%s";
    private final PaymentRefundClient refundClient;

    public PaymentClient() {
        this(MercadoPagoConfig.getHttpClient());
    }

    public PaymentClient(MPHttpClient httpClient) {
        super(httpClient);
        this.refundClient = new PaymentRefundClient(httpClient);
        StreamHandler streamHandler = MercadoPagoConfig.getStreamHandler();
        streamHandler.setLevel(MercadoPagoConfig.getLoggingLevel());
        LOGGER.addHandler(streamHandler);
        LOGGER.setLevel(MercadoPagoConfig.getLoggingLevel());
    }

    public Payment get(Long id) throws MPException, MPApiException {
        return this.get(id, null);
    }

    public Payment get(Long id, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending get payment request");
        MPResponse response = this.send(String.format(URL_WITH_ID, id.toString()), HttpMethod.GET, null, null, requestOptions);
        Payment result = Serializer.deserializeFromJson(Payment.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public Payment create(PaymentCreateRequest request) throws MPException, MPApiException {
        return this.create(request, null);
    }

    public Payment create(PaymentCreateRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending create payment request");
        MPRequest mpRequest = MPRequest.builder().uri("/v1/payments").method(HttpMethod.POST).payload(Serializer.serializeToJson(request)).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        Payment result = Serializer.deserializeFromJson(Payment.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public Payment cancel(Long id) throws MPException, MPApiException {
        return this.cancel(id, null);
    }

    public Payment cancel(Long id, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending cancel payment request");
        PaymentCancelRequest payload = new PaymentCancelRequest();
        MPResponse response = this.send(String.format(URL_WITH_ID, id.toString()), HttpMethod.PUT, Serializer.serializeToJson(payload), new HashMap<String, Object>(), requestOptions);
        Payment result = Serializer.deserializeFromJson(Payment.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public Payment capture(Long id) throws MPException, MPApiException {
        return this.capture(id, null, null);
    }

    public Payment capture(Long id, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.capture(id, null, requestOptions);
    }

    public Payment capture(Long id, BigDecimal amount) throws MPException, MPApiException {
        return this.capture(id, amount, null);
    }

    public Payment capture(Long id, BigDecimal amount, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending capture payment request");
        PaymentCaptureRequest payload = PaymentCaptureRequest.builder().transactionAmount(amount).build();
        MPResponse response = this.send(String.format(URL_WITH_ID, id.toString()), HttpMethod.PUT, Serializer.serializeToJson(payload), new HashMap<String, Object>(), requestOptions);
        Payment result = Serializer.deserializeFromJson(Payment.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public MPResultsResourcesPage<Payment> search(MPSearchRequest request) throws MPException, MPApiException {
        return this.search(request, null);
    }

    public MPResultsResourcesPage<Payment> search(MPSearchRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending search payment request");
        MPResponse response = this.search("/v1/payments/search", request, requestOptions);
        Type responseType = new TypeToken<MPResultsResourcesPage<Payment>>(){}.getType();
        MPResultsResourcesPage<Payment> result = Serializer.deserializeResultsResourcesPageFromJson(responseType, response.getContent());
        result.setResponse(response);
        return result;
    }

    public PaymentRefund refund(Long paymentId) throws MPException, MPApiException {
        return this.refund(paymentId, null, null);
    }

    public PaymentRefund refund(Long paymentId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.refund(paymentId, null, requestOptions);
    }

    public PaymentRefund refund(Long paymentId, BigDecimal amount) throws MPException, MPApiException {
        return this.refund(paymentId, amount, null);
    }

    public PaymentRefund refund(Long paymentId, BigDecimal amount, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.refundClient.refund(paymentId, amount, requestOptions);
    }

    public PaymentRefund getRefund(Long paymentId, Long refundId) throws MPException, MPApiException {
        return this.getRefund(paymentId, refundId, null);
    }

    public PaymentRefund getRefund(Long paymentId, Long refundId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.refundClient.get(paymentId, refundId, requestOptions);
    }

    public MPResourceList<PaymentRefund> listRefunds(Long paymentId) throws MPException, MPApiException {
        return this.listRefunds(paymentId, null);
    }

    public MPResourceList<PaymentRefund> listRefunds(Long paymentId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.refundClient.list(paymentId, requestOptions);
    }
}

