/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

import com.mercadopago.client.payment.PaymentAuthenticationRequest;
import com.mercadopago.client.payment.PaymentRulesRequest;

public class PaymentDataRequest {
    private final PaymentRulesRequest rules;
    private final PaymentAuthenticationRequest authentication;

    PaymentDataRequest(PaymentRulesRequest rules, PaymentAuthenticationRequest authentication) {
        this.rules = rules;
        this.authentication = authentication;
    }

    public static PaymentDataRequestBuilder builder() {
        return new PaymentDataRequestBuilder();
    }

    public PaymentRulesRequest getRules() {
        return this.rules;
    }

    public PaymentAuthenticationRequest getAuthentication() {
        return this.authentication;
    }

    public static class PaymentDataRequestBuilder {
        private PaymentRulesRequest rules;
        private PaymentAuthenticationRequest authentication;

        PaymentDataRequestBuilder() {
        }

        public PaymentDataRequestBuilder rules(PaymentRulesRequest rules) {
            this.rules = rules;
            return this;
        }

        public PaymentDataRequestBuilder authentication(PaymentAuthenticationRequest authentication) {
            this.authentication = authentication;
            return this;
        }

        public PaymentDataRequest build() {
            return new PaymentDataRequest(this.rules, this.authentication);
        }

        public String toString() {
            return "PaymentDataRequest.PaymentDataRequestBuilder(rules=" + this.rules + ", authentication=" + this.authentication + ")";
        }
    }
}

