/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.point;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class PointPaymentIntentListRequest {
    private final LocalDate startDate;
    private final LocalDate endDate;

    public Map<String, Object> getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("startDate", this.startDate);
        params.put("endDate", this.endDate);
        return params;
    }

    PointPaymentIntentListRequest(LocalDate startDate, LocalDate endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public static PointPaymentIntentListRequestBuilder builder() {
        return new PointPaymentIntentListRequestBuilder();
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public static class PointPaymentIntentListRequestBuilder {
        private LocalDate startDate;
        private LocalDate endDate;

        PointPaymentIntentListRequestBuilder() {
        }

        public PointPaymentIntentListRequestBuilder startDate(LocalDate startDate) {
            this.startDate = startDate;
            return this;
        }

        public PointPaymentIntentListRequestBuilder endDate(LocalDate endDate) {
            this.endDate = endDate;
            return this;
        }

        public PointPaymentIntentListRequest build() {
            return new PointPaymentIntentListRequest(this.startDate, this.endDate);
        }

        public String toString() {
            return "PointPaymentIntentListRequest.PointPaymentIntentListRequestBuilder(startDate=" + this.startDate + ", endDate=" + this.endDate + ")";
        }
    }
}

