/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.preapproval;

import com.google.gson.reflect.TypeToken;
import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.client.MercadoPagoClient;
import com.mercadopago.client.preapproval.PreapprovalCreateRequest;
import com.mercadopago.client.preapproval.PreapprovalUpdateRequest;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPResponse;
import com.mercadopago.net.MPResultsResourcesPage;
import com.mercadopago.net.MPSearchRequest;
import com.mercadopago.resources.preapproval.Preapproval;
import com.mercadopago.serialization.Serializer;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class PreapprovalClient
extends MercadoPagoClient {
    private static final Logger LOGGER = Logger.getLogger(PreapprovalClient.class.getName());
    private static final String URL_WITH_ID = "/preapproval/%s";

    public PreapprovalClient() {
        this(MercadoPagoConfig.getHttpClient());
    }

    public PreapprovalClient(MPHttpClient httpClient) {
        super(httpClient);
        StreamHandler streamHandler = MercadoPagoConfig.getStreamHandler();
        streamHandler.setLevel(MercadoPagoConfig.getLoggingLevel());
        LOGGER.addHandler(streamHandler);
        LOGGER.setLevel(MercadoPagoConfig.getLoggingLevel());
    }

    public Preapproval get(String id) throws MPException, MPApiException {
        return this.get(id, null);
    }

    public Preapproval get(String id, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending get preapproval request");
        MPResponse response = this.send(String.format(URL_WITH_ID, id), HttpMethod.GET, null, null, requestOptions);
        Preapproval result = Serializer.deserializeFromJson(Preapproval.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public Preapproval create(PreapprovalCreateRequest request) throws MPException, MPApiException {
        return this.create(request, null);
    }

    public Preapproval create(PreapprovalCreateRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending create preapproval request");
        MPResponse response = this.send("/preapproval", HttpMethod.POST, Serializer.serializeToJson(request), null, requestOptions);
        Preapproval result = Serializer.deserializeFromJson(Preapproval.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public Preapproval update(String id, PreapprovalUpdateRequest request) throws MPException, MPApiException {
        return this.update(id, request, null);
    }

    public Preapproval update(String id, PreapprovalUpdateRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending update preapproval request");
        MPResponse response = this.send(String.format(URL_WITH_ID, id), HttpMethod.PUT, Serializer.serializeToJson(request), null, requestOptions);
        Preapproval result = Serializer.deserializeFromJson(Preapproval.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public MPResultsResourcesPage<Preapproval> search(MPSearchRequest request) throws MPException, MPApiException {
        return this.search(request, null);
    }

    public MPResultsResourcesPage<Preapproval> search(MPSearchRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending search preapproval request");
        MPResponse response = this.search("/preapproval/search", request, requestOptions);
        Type responseType = new TypeToken<MPResultsResourcesPage<Preapproval>>(){}.getType();
        MPResultsResourcesPage<Preapproval> result = Serializer.deserializeResultsResourcesPageFromJson(responseType, response.getContent());
        result.setResponse(response);
        return result;
    }
}

