/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.resources.order;

public class OrderAutomaticPayments {
    private String paymentProfileId;
    private Integer retries;
    private String scheduleDate;
    private String dueDate;

    OrderAutomaticPayments(String paymentProfileId, Integer retries, String scheduleDate, String dueDate) {
        this.paymentProfileId = paymentProfileId;
        this.retries = retries;
        this.scheduleDate = scheduleDate;
        this.dueDate = dueDate;
    }

    public static OrderAutomaticPaymentsBuilder builder() {
        return new OrderAutomaticPaymentsBuilder();
    }

    public String getPaymentProfileId() {
        return this.paymentProfileId;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public String getScheduleDate() {
        return this.scheduleDate;
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public static class OrderAutomaticPaymentsBuilder {
        private String paymentProfileId;
        private Integer retries;
        private String scheduleDate;
        private String dueDate;

        OrderAutomaticPaymentsBuilder() {
        }

        public OrderAutomaticPaymentsBuilder paymentProfileId(String paymentProfileId) {
            this.paymentProfileId = paymentProfileId;
            return this;
        }

        public OrderAutomaticPaymentsBuilder retries(Integer retries) {
            this.retries = retries;
            return this;
        }

        public OrderAutomaticPaymentsBuilder scheduleDate(String scheduleDate) {
            this.scheduleDate = scheduleDate;
            return this;
        }

        public OrderAutomaticPaymentsBuilder dueDate(String dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public OrderAutomaticPayments build() {
            return new OrderAutomaticPayments(this.paymentProfileId, this.retries, this.scheduleDate, this.dueDate);
        }

        public String toString() {
            return "OrderAutomaticPayments.OrderAutomaticPaymentsBuilder(paymentProfileId=" + this.paymentProfileId + ", retries=" + this.retries + ", scheduleDate=" + this.scheduleDate + ", dueDate=" + this.dueDate + ")";
        }
    }
}

