/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.resources.order;

public class OrderStoredCredential {
    private String paymentInitiator;
    private String reason;
    private Boolean storePaymentMethod;
    private Boolean firstPayment;

    OrderStoredCredential(String paymentInitiator, String reason, Boolean storePaymentMethod, Boolean firstPayment) {
        this.paymentInitiator = paymentInitiator;
        this.reason = reason;
        this.storePaymentMethod = storePaymentMethod;
        this.firstPayment = firstPayment;
    }

    public static OrderStoredCredentialBuilder builder() {
        return new OrderStoredCredentialBuilder();
    }

    public String getPaymentInitiator() {
        return this.paymentInitiator;
    }

    public String getReason() {
        return this.reason;
    }

    public Boolean getStorePaymentMethod() {
        return this.storePaymentMethod;
    }

    public Boolean getFirstPayment() {
        return this.firstPayment;
    }

    public static class OrderStoredCredentialBuilder {
        private String paymentInitiator;
        private String reason;
        private Boolean storePaymentMethod;
        private Boolean firstPayment;

        OrderStoredCredentialBuilder() {
        }

        public OrderStoredCredentialBuilder paymentInitiator(String paymentInitiator) {
            this.paymentInitiator = paymentInitiator;
            return this;
        }

        public OrderStoredCredentialBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public OrderStoredCredentialBuilder storePaymentMethod(Boolean storePaymentMethod) {
            this.storePaymentMethod = storePaymentMethod;
            return this;
        }

        public OrderStoredCredentialBuilder firstPayment(Boolean firstPayment) {
            this.firstPayment = firstPayment;
            return this;
        }

        public OrderStoredCredential build() {
            return new OrderStoredCredential(this.paymentInitiator, this.reason, this.storePaymentMethod, this.firstPayment);
        }

        public String toString() {
            return "OrderStoredCredential.OrderStoredCredentialBuilder(paymentInitiator=" + this.paymentInitiator + ", reason=" + this.reason + ", storePaymentMethod=" + this.storePaymentMethod + ", firstPayment=" + this.firstPayment + ")";
        }
    }
}

