/*
 * Decompiled with CFR 0.152.
 */
package com.modrinth.minotaur;

import com.modrinth.minotaur.ModrinthExtension;
import com.modrinth.minotaur.TaskModrinthSyncBody;
import com.modrinth.minotaur.TaskModrinthUpload;
import com.modrinth.minotaur.Util;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class Minotaur
implements Plugin<Project> {
    public void apply(Project project) {
        project.getExtensions().create("modrinth", ModrinthExtension.class, new Object[]{project});
        project.getLogger().debug("Created the `modrinth` extension.");
        TaskContainer tasks = project.getTasks();
        tasks.register("modrinth", TaskModrinthUpload.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Upload project to Modrinth");
            task.dependsOn(new Object[]{tasks.named("assemble")});
            task.mustRunAfter(new Object[]{tasks.named("build")});
            task.notCompatibleWithConfigurationCache("Fundamentally incompatible with configuration cache");
        });
        project.getLogger().debug("Registered the `modrinth` task.");
        tasks.register("modrinthSyncBody", TaskModrinthSyncBody.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Sync project description to Modrinth");
            task.notCompatibleWithConfigurationCache("Fundamentally incompatible with configuration cache");
        });
        project.getLogger().debug("Registered the `modrinthSyncBody` task.");
        project.afterEvaluate(evaluatedProject -> {
            ModrinthExtension ext = Util.ext(evaluatedProject);
            if (!((Boolean)ext.getAutoAddDependsOn().getOrElse((Object)true)).booleanValue()) {
                return;
            }
            evaluatedProject.getTasks().named("modrinth", TaskModrinthUpload.class).configure(task -> {
                task.getWiredInputFiles().from(new Object[]{ext.getFile()});
                task.getInputs().property("changelog", ext.getChangelog()).optional(true);
                ((List)ext.getAdditionalFiles().get()).forEach(file -> {
                    if (file == null) {
                        return;
                    }
                    if (file instanceof AbstractArchiveTask) {
                        task.dependsOn(new Object[]{file});
                    } else if (file instanceof TaskProvider && ((TaskProvider)file).get() instanceof AbstractArchiveTask) {
                        task.dependsOn(new Object[]{((TaskProvider)file).get()});
                    }
                });
                evaluatedProject.getLogger().debug("Made the `modrinth` task depend on the upload file and additional files.");
            });
        });
        project.getLogger().debug("Successfully applied the Modrinth plugin!");
    }
}

