/*
 * Decompiled with CFR 0.152.
 */
package com.modrinth.minotaur;

import com.google.gson.JsonObject;
import com.modrinth.minotaur.ModrinthExtension;
import com.modrinth.minotaur.Util;
import java.util.Objects;
import java.util.regex.Pattern;
import masecla.modrinth4j.endpoints.project.ModifyProject;
import masecla.modrinth4j.main.ModrinthAPI;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class TaskModrinthSyncBody
extends DefaultTask {
    @TaskAction
    public void apply() {
        this.getLogger().lifecycle("Minotaur: {}", new Object[]{((Object)((Object)this)).getClass().getPackage().getImplementationVersion()});
        ModrinthExtension ext = Util.ext(this.getProject());
        try {
            if (ext.getSyncBodyFrom() == null) {
                throw new GradleException("Sync project body task was called, but `syncBodyFrom` was null!");
            }
            ModrinthAPI api = Util.api(this.getProject());
            String id = Objects.requireNonNull((String)api.projects().getProjectIdBySlug((String)ext.getProjectId().get()).join(), "Failed to resolve project ID: " + (String)ext.getProjectId().get());
            this.getLogger().debug("Syncing body to project {}", (Object)id);
            Pattern excludeRegex = Pattern.compile("<!-- modrinth_exclude\\.start -->.*?<!-- modrinth_exclude\\.end -->", 32);
            String body = ((String)ext.getSyncBodyFrom().get()).replaceAll("\r\n", "\n");
            body = excludeRegex.matcher(body).replaceAll("");
            if (((Boolean)ext.getDebugMode().get()).booleanValue()) {
                JsonObject data = new JsonObject();
                data.addProperty("body", body);
                this.getLogger().lifecycle("Full data to be sent for upload: {}", new Object[]{data});
                this.getLogger().lifecycle("Minotaur debug mode is enabled. Not going to upload the body.");
                return;
            }
            api.projects().modify(id, ModifyProject.ProjectModifications.builder().body(body).build()).join();
            this.getLogger().lifecycle("Successfully synced body to project {}.", new Object[]{ext.getProjectId().get()});
        }
        catch (Exception e) {
            if (((Boolean)ext.getFailSilently().get()).booleanValue()) {
                this.getLogger().info("Failed to sync body to Modrinth. Check logs for more info.");
                this.getLogger().error("Modrinth body sync failed silently.", (Throwable)e);
            }
            throw new GradleException("Failed to sync project body! " + e.getMessage(), (Throwable)e);
        }
    }
}

