/*
 * Decompiled with CFR 0.152.
 */
package com.modrinth.minotaur;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.modrinth.minotaur.ModrinthExtension;
import com.modrinth.minotaur.Util;
import com.modrinth.minotaur.dependencies.Dependency;
import com.modrinth.minotaur.responses.ResponseUpload;
import com.modrinth.minotaur.scanner.JarInfectionScanner;
import io.papermc.paperweight.userdev.PaperweightUserExtension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import masecla.modrinth4j.endpoints.version.CreateVersion;
import masecla.modrinth4j.main.ModrinthAPI;
import masecla.modrinth4j.model.version.ProjectVersion;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.ApiStatus;

public abstract class TaskModrinthUpload
extends DefaultTask {
    @Nullable
    public ProjectVersion newVersion = null;
    @Nullable
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public ResponseUpload uploadInfo = null;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public boolean wasUploadSuccessful() {
        return this.newVersion != null;
    }

    @InputFiles
    @Optional
    @ApiStatus.Internal
    public abstract ConfigurableFileCollection getWiredInputFiles();

    @TaskAction
    public void apply() {
        this.getLogger().lifecycle("Minotaur: {}", new Object[]{((Object)((Object)this)).getClass().getPackage().getImplementationVersion()});
        ModrinthExtension ext = Util.ext(this.getProject());
        PluginManager pluginManager = this.getProject().getPluginManager();
        try {
            ProjectVersion version;
            ModrinthAPI api = Util.api(this.getProject());
            String slug = (String)ext.getProjectId().get();
            String id = (String)api.projects().getProjectIdBySlug(slug).join();
            if (id == null) {
                if (((Boolean)ext.getDebugMode().get()).booleanValue()) {
                    this.getLogger().error("Cannot find project with id '{}'.", (Object)slug);
                    id = "<unknown>";
                } else {
                    throw new GradleException(String.format("Cannot find project with id '%s'", slug));
                }
            }
            this.getLogger().debug("Uploading version to project {}", (Object)id);
            String versionNumber = Util.resolveVersionNumber(this.getProject());
            if (ext.getVersionName().getOrNull() == null) {
                ext.getVersionName().set((Object)versionNumber);
            }
            if (((List)ext.getLoaders().get()).isEmpty() && ((Boolean)ext.getDetectLoaders().get()).booleanValue()) {
                HashMap<String, String> pluginLoaderMap = new HashMap<String, String>();
                pluginLoaderMap.put("net.minecraftforge.gradle", "forge");
                pluginLoaderMap.put("net.neoforged.gradle", "neoforge");
                pluginLoaderMap.put("net.neoforged.gradle.userdev", "neoforge");
                pluginLoaderMap.put("net.neoforged.moddev", "neoforge");
                pluginLoaderMap.put("net.neoforged.moddev.legacyforge", "forge");
                pluginLoaderMap.put("org.quiltmc.loom", "quilt");
                pluginLoaderMap.put("org.spongepowered.gradle.plugin", "sponge");
                pluginLoaderMap.put("io.papermc.paperweight.userdev", "paper");
                pluginLoaderMap.put("xyz.jpenilla.run-paper", "paper");
                pluginLoaderMap.put("xyz.jpenilla.run-waterfall", "waterfall");
                pluginLoaderMap.put("xyz.jpenilla.run-velocity", "velocity");
                pluginLoaderMap.forEach((plugin, loader) -> {
                    if (pluginManager.hasPlugin(plugin)) {
                        this.getLogger().debug("Adding loader '{}' because plugin '{}' was found.", loader, plugin);
                        TaskModrinthUpload.add(ext.getLoaders(), loader);
                    }
                });
                if (!((List)ext.getLoaders().get()).contains("quilt") && this.getProject().getExtensions().findByName("loom") != null) {
                    Object object = this.getProject().findProperty("loom.platform");
                    if (object != null) {
                        this.getLogger().debug("Adding loader '{}' because 'loom' extension was found and loom.platform={}.", object, object);
                        TaskModrinthUpload.add(ext.getLoaders(), (String)object);
                    } else {
                        this.getLogger().debug("Adding loader 'fabric' because 'loom' extension was found.");
                        TaskModrinthUpload.add(ext.getLoaders(), "fabric");
                    }
                }
            }
            if (((List)ext.getLoaders().get()).isEmpty()) {
                throw new GradleException("Cannot upload to Modrinth: no loaders specified!");
            }
            if (((List)ext.getGameVersions().get()).isEmpty()) {
                String version2;
                if (pluginManager.hasPlugin("net.minecraftforge.gradle") || pluginManager.hasPlugin("net.neoforged.gradle") || pluginManager.hasPlugin("net.neoforged.gradle.userdev")) {
                    String[] props;
                    for (String prop : props = new String[]{"MC_VERSION", "minecraftVersion"}) {
                        try {
                            String version3 = (String)this.getProject().getExtensions().getExtraProperties().get(prop);
                            if (version3 == null) continue;
                            this.getLogger().debug("Adding fallback game version {} from ForgeGradle/NeoGradle.", (Object)version3);
                            TaskModrinthUpload.add(ext.getGameVersions(), version3);
                            break;
                        }
                        catch (Exception e) {
                            this.getLogger().debug("Could not find property {}", (Object)prop);
                        }
                    }
                }
                if (this.getProject().getExtensions().findByName("loom") != null && (version2 = ((org.gradle.api.artifacts.Dependency)this.getProject().getConfigurations().getByName("minecraft").getDependencies().iterator().next()).getVersion()) != null) {
                    this.getLogger().debug("Adding fallback game version {} from Loom.", (Object)version2);
                    TaskModrinthUpload.add(ext.getGameVersions(), version2);
                }
                if (this.getProject().getExtensions().findByName("paperweight") != null) {
                    String mcVer = (String)((PaperweightUserExtension)this.getProject().getExtensions().getByType(PaperweightUserExtension.class)).getMinecraftVersion().get();
                    this.getLogger().debug("Adding fallback game version {} from paperweight-userdev.", (Object)mcVer);
                    TaskModrinthUpload.add(ext.getGameVersions(), mcVer);
                }
            }
            if (((List)ext.getGameVersions().get()).isEmpty()) {
                throw new GradleException("Cannot upload to Modrinth: no game versions specified!");
            }
            ArrayList<Dependency> protoDependencies = new ArrayList<Dependency>();
            ArrayList arrayList = new ArrayList();
            protoDependencies.addAll(ext.getNamedDependenciesAsList());
            protoDependencies.addAll((Collection)ext.getDependencies().get());
            protoDependencies.stream().map(dependency -> dependency.toNew(api)).forEach(arrayList::add);
            ArrayList<File> files = new ArrayList<File>();
            files.add(((RegularFile)ext.getFile().get()).getAsFile());
            ((List)ext.getAdditionalFiles().get()).forEach(file -> {
                File resolvedFile = Util.resolveFile(this.getProject(), file);
                if (resolvedFile == null || !resolvedFile.exists()) {
                    throw new GradleException("The upload file is missing or null. " + file);
                }
                files.add(resolvedFile);
            });
            files.forEach(file -> {
                try (ZipFile zipFile = new ZipFile((File)file);){
                    JarInfectionScanner.scan(this.getLogger(), zipFile);
                }
                catch (ZipException e) {
                    this.getLogger().warn("Failed to scan {}. Not a valid zip or jar file", (Object)file.getName(), (Object)e);
                }
                catch (IOException e) {
                    throw new GradleException(String.format("Failed to scan %s", file.getName()), (Throwable)e);
                }
            });
            CreateVersion.CreateVersionRequest data = CreateVersion.CreateVersionRequest.builder().projectId(id).versionNumber(versionNumber).name((String)ext.getVersionName().get()).changelog(((String)ext.getChangelog().get()).replaceAll("\r\n", "\n")).versionType(ProjectVersion.VersionType.valueOf((String)((String)ext.getVersionType().get()).toUpperCase(Locale.ROOT))).gameVersions((List)ext.getGameVersions().get()).loaders((List)ext.getLoaders().get()).dependencies(arrayList).files(files).build();
            if (((Boolean)ext.getDebugMode().get()).booleanValue()) {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                this.getLogger().lifecycle("Full data to be sent for upload: {}", new Object[]{gson.toJson((Object)data)});
                this.getLogger().lifecycle("Minotaur debug mode is enabled. Not going to upload this version.");
                return;
            }
            this.newVersion = version = (ProjectVersion)api.versions().createProjectVersion(data).join();
            this.uploadInfo = new ResponseUpload(version);
            this.getLogger().lifecycle("Successfully uploaded version {} to {} ({}) as version ID {}. {}", new Object[]{this.newVersion.getVersionNumber(), slug, id, this.newVersion.getId(), String.format("%s/project/%s/version/%s", ((String)ext.getApiUrl().get()).replaceFirst("-?api", "").replaceFirst("/?v2/?", "").replaceFirst("//\\.", "//"), id, this.newVersion.getId())});
        }
        catch (Exception e) {
            if (((Boolean)ext.getFailSilently().get()).booleanValue()) {
                this.getLogger().info("Failed to upload to Modrinth. Check logs for more info.");
                this.getLogger().error("Modrinth upload failed silently.", (Throwable)e);
            }
            throw new GradleException("Failed to upload file to Modrinth! " + e.getMessage(), (Throwable)e);
        }
    }

    private static <T> void add(ListProperty<T> list, T element) {
        if (!((List)list.get()).contains(element)) {
            list.add(element);
        }
    }
}

