/*
 * Decompiled with CFR 0.152.
 */
package com.modrinth.minotaur;

import com.modrinth.minotaur.ModrinthExtension;
import java.io.File;
import masecla.modrinth4j.client.agent.UserAgent;
import masecla.modrinth4j.main.ModrinthAPI;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
class Util {
    Util() {
    }

    static ModrinthAPI api(Project project) {
        ModrinthExtension ext = Util.ext(project);
        String url = (String)ext.getApiUrl().get();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        UserAgent agent = UserAgent.builder().authorUsername("modrinth").projectName("minotaur").projectVersion(Util.class.getPackage().getImplementationVersion()).contact((String)ext.getProjectId().get() + "/" + Util.resolveVersionNumber(project)).build();
        String token = (String)ext.getToken().get();
        if (token.startsWith("mra")) {
            throw new RuntimeException("Token must be a personal-access token, not a session token!");
        }
        if (!token.startsWith("mrp")) {
            project.getLogger().warn("Using GitHub tokens for authentication is deprecated. Please begin to use personal-access tokens.");
        }
        return ModrinthAPI.rateLimited((UserAgent)agent, (String)url, (String)token);
    }

    static ModrinthExtension ext(Project project) {
        return (ModrinthExtension)project.getExtensions().getByType(ModrinthExtension.class);
    }

    static String resolveVersionNumber(Project project) {
        ModrinthExtension ext = Util.ext(project);
        if (ext.getVersionNumber().getOrNull() == null) {
            ext.getVersionNumber().set((Object)project.getVersion().toString());
        }
        return (String)ext.getVersionNumber().get();
    }

    @Nullable
    static File resolveFile(Project project, Object in) {
        Object provided;
        if (in == null) {
            return null;
        }
        if (in instanceof File) {
            return (File)in;
        }
        if (in instanceof AbstractArchiveTask) {
            return ((RegularFile)((AbstractArchiveTask)in).getArchiveFile().get()).getAsFile();
        }
        if (in instanceof TaskProvider && (provided = ((TaskProvider)in).get()) instanceof AbstractArchiveTask) {
            return ((RegularFile)((AbstractArchiveTask)provided).getArchiveFile().get()).getAsFile();
        }
        return project.file(in);
    }

    static Provider<RegularFile> resolveFileProperty(Project project, Object in) {
        if (in == null) {
            return project.getObjects().fileProperty();
        }
        if (in instanceof File) {
            return project.getLayout().file(project.provider(() -> (File)in));
        }
        if (in instanceof AbstractArchiveTask) {
            return ((AbstractArchiveTask)in).getArchiveFile();
        }
        if (in instanceof TaskProvider) {
            Object provided = ((TaskProvider)in).get();
            return ((TaskProvider)in).flatMap(task -> {
                if (provided instanceof AbstractArchiveTask) {
                    return ((AbstractArchiveTask)provided).getArchiveFile();
                }
                return project.getLayout().file(project.provider(() -> project.file(in)));
            });
        }
        return project.getLayout().file(project.provider(() -> project.file(in)));
    }
}

