/*
 * Decompiled with CFR 0.152.
 */
package com.modrinth.minotaur.dependencies.container;

import com.modrinth.minotaur.dependencies.DependencyType;
import com.modrinth.minotaur.dependencies.container.NamedDependency;
import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectContainer;

public class NamedDependencyContainer {
    private final NamedDomainObjectContainer<NamedDependency> dependencyContainer;
    private final DependencyType dependencyType;

    @Inject
    protected NamedDependencyContainer(NamedDomainObjectContainer<NamedDependency> container, DependencyType dependencyType) {
        this.dependencyContainer = container;
        this.dependencyType = dependencyType;
    }

    public void project(String ... projectIds) {
        for (String projectId : projectIds) {
            this.dependencyContainer.add((Object)new NamedDependency(projectId, null, this.dependencyType));
        }
    }

    public void version(String ... versionIds) {
        for (String versionId : versionIds) {
            this.dependencyContainer.add((Object)new NamedDependency(null, versionId, this.dependencyType));
        }
    }

    public void version(String projectId, String versionId) {
        this.dependencyContainer.add((Object)new NamedDependency(projectId, versionId, this.dependencyType));
    }

    public static class Embedded
    extends NamedDependencyContainer {
        @Inject
        public Embedded(NamedDomainObjectContainer<NamedDependency> container) {
            super(container, DependencyType.EMBEDDED);
        }
    }

    public static class Required
    extends NamedDependencyContainer {
        @Inject
        public Required(NamedDomainObjectContainer<NamedDependency> container) {
            super(container, DependencyType.REQUIRED);
        }
    }

    public static class Optional
    extends NamedDependencyContainer {
        @Inject
        public Optional(NamedDomainObjectContainer<NamedDependency> container) {
            super(container, DependencyType.OPTIONAL);
        }
    }

    public static class Incompatible
    extends NamedDependencyContainer {
        @Inject
        public Incompatible(NamedDomainObjectContainer<NamedDependency> container) {
            super(container, DependencyType.INCOMPATIBLE);
        }
    }
}

