/*
 * Decompiled with CFR 0.152.
 */
package com.modrinth.minotaur.scanner;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class JarInfectionScanner {
    private static final AbstractInsnNode[] SIG1 = new AbstractInsnNode[]{new TypeInsnNode(187, "java/lang/String"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new TypeInsnNode(187, "java/lang/String"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new MethodInsnNode(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;"), new MethodInsnNode(182, "java/lang/Class", "getConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new MethodInsnNode(183, "java/net/URL", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)V"), new MethodInsnNode(182, "java/lang/reflect/Constructor", "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;"), new MethodInsnNode(184, "java/lang/Class", "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new MethodInsnNode(182, "java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;"), new MethodInsnNode(182, "java/lang/reflect/Method", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;")};
    private static final AbstractInsnNode[] SIG2 = new AbstractInsnNode[]{new MethodInsnNode(184, "java/lang/Runtime", "getRuntime", "()Ljava/lang/Runtime;"), new MethodInsnNode(184, "java/util/Base64", "getDecoder", "()Ljava/util/Base64$Decoder;"), new MethodInsnNode(182, "java/lang/String", "concat", "(Ljava/lang/String;)Ljava/lang/String;"), new MethodInsnNode(182, "java/util/Base64$Decoder", "decode", "(Ljava/lang/String;)[B"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new MethodInsnNode(182, "java/io/File", "getPath", "()Ljava/lang/String;"), new MethodInsnNode(182, "java/lang/Runtime", "exec", "([Ljava/lang/String;)Ljava/lang/Process;")};
    private static final AbstractInsnNode[] SIG3 = new AbstractInsnNode[]{new IntInsnNode(16, 56), new InsnNode(84), new InsnNode(89), new InsnNode(4), new IntInsnNode(16, 53), new InsnNode(84), new InsnNode(89), new InsnNode(5), new IntInsnNode(16, 46), new InsnNode(84), new InsnNode(89), new InsnNode(6), new IntInsnNode(16, 50), new InsnNode(84), new InsnNode(89), new InsnNode(7), new IntInsnNode(16, 49), new InsnNode(84), new InsnNode(89), new InsnNode(8), new IntInsnNode(16, 55), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 6), new IntInsnNode(16, 46), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 7), new IntInsnNode(16, 49), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 8), new IntInsnNode(16, 52), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 9), new IntInsnNode(16, 52), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 10), new IntInsnNode(16, 46), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 11), new IntInsnNode(16, 49), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 12), new IntInsnNode(16, 51), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 13), new IntInsnNode(16, 48)};

    public static void scan(Logger logger, ZipFile file) {
        try {
            boolean matches = file.stream().filter(entry -> entry.getName().endsWith(".class")).anyMatch(entry -> {
                try {
                    return JarInfectionScanner.scanClass(JarInfectionScanner.getByteArray(file.getInputStream((ZipEntry)entry)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            try {
                file.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!matches) {
                return;
            }
            throw new GradleException(String.format("!!!! %s is infected with Fractureiser", file.getName()));
        }
        catch (Exception e) {
            logger.error("Failed to scan {}", (Object)file.getName(), (Object)e);
            logger.info("Fractureiser not detected in {}", (Object)file.getName());
            return;
        }
    }

    private static byte[] getByteArray(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    private static boolean same(AbstractInsnNode a, AbstractInsnNode b) {
        if (a instanceof TypeInsnNode) {
            TypeInsnNode aa = (TypeInsnNode)a;
            return aa.desc.equals(((TypeInsnNode)b).desc);
        }
        if (a instanceof MethodInsnNode) {
            MethodInsnNode aa = (MethodInsnNode)a;
            return aa.owner.equals(((MethodInsnNode)b).owner) && aa.name.equals(((MethodInsnNode)b).name) && aa.desc.equals(((MethodInsnNode)b).desc);
        }
        if (a instanceof InsnNode) {
            return true;
        }
        throw new IllegalArgumentException("TYPE NOT ADDED");
    }

    public static boolean scanClass(byte[] clazz) {
        ClassReader reader = new ClassReader(clazz);
        ClassNode node = new ClassNode();
        try {
            reader.accept((ClassVisitor)node, 0);
        }
        catch (Exception e) {
            return false;
        }
        for (MethodNode method : node.methods) {
            AbstractInsnNode insn;
            int i;
            boolean match = true;
            int j = 0;
            for (i = 0; i < method.instructions.size() && j < SIG1.length; ++i) {
                insn = method.instructions.get(i);
                if (insn.getOpcode() == -1 || insn.getOpcode() != SIG1[j].getOpcode() || JarInfectionScanner.same(insn, SIG1[j++])) continue;
                match = false;
                break;
            }
            if (j != SIG1.length) {
                match = false;
            }
            if (match) {
                return true;
            }
            match = false;
            block4: for (int q = 0; q < method.instructions.size(); ++q) {
                int j2 = 0;
                for (int i2 = q; i2 < method.instructions.size() && j2 < SIG2.length; ++i2) {
                    AbstractInsnNode insn2 = method.instructions.get(i2);
                    if (insn2.getOpcode() == SIG2[j2].getOpcode() && insn2.getOpcode() == SIG2[j2].getOpcode() && !JarInfectionScanner.same(insn2, SIG2[j2++])) continue block4;
                }
                if (j2 != SIG2.length) continue;
                match = true;
                break;
            }
            if (match) {
                return true;
            }
            match = false;
            int pos = 0;
            for (i = 0; i < method.instructions.size() && pos != SIG3.length; ++i) {
                insn = method.instructions.get(i);
                if (insn.getOpcode() == -1) continue;
                if (insn.getOpcode() == SIG3[pos].getOpcode()) {
                    if (SIG3[pos].getType() == 1) {
                        IntInsnNode iInsn = (IntInsnNode)insn;
                        IntInsnNode sigInsn = (IntInsnNode)SIG3[pos];
                        if (iInsn.operand != sigInsn.operand) continue;
                        match = true;
                        ++pos;
                        continue;
                    }
                    match = true;
                    ++pos;
                    continue;
                }
                match = false;
                pos = 0;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }
}

