/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AbstractAutomaticBean;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ChecksAndFilesSuppressionFileGeneratorAuditListener
extends AbstractAutomaticBean
implements AuditListener {
    private static final String QUOTE_CHAR = "\"";
    private final PrintWriter writer;
    private final boolean closeStream;
    private final Map<Path, Set<String>> filesAndChecksCollector = new HashMap<Path, Set<String>>();
    private final Map<Path, Set<String>> filesAndModuleIdCollector = new HashMap<Path, Set<String>>();
    private boolean isXmlHeaderPrinted;

    public ChecksAndFilesSuppressionFileGeneratorAuditListener(OutputStream out, AbstractAutomaticBean.OutputStreamOptions outputStreamOptions) {
        this.writer = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        this.closeStream = outputStreamOptions == AbstractAutomaticBean.OutputStreamOptions.CLOSE;
    }

    @Override
    public void fileStarted(AuditEvent event) {
    }

    @Override
    public void fileFinished(AuditEvent event) {
    }

    @Override
    public void auditStarted(AuditEvent event) {
    }

    @Override
    public void auditFinished(AuditEvent event) {
        if (this.isXmlHeaderPrinted) {
            this.writer.println("</suppressions>");
        }
        this.writer.flush();
        if (this.closeStream) {
            this.writer.close();
        }
    }

    @Override
    public void addError(AuditEvent event) {
        this.printXmlHeader();
        Path path = Path.of(event.getFileName(), new String[0]);
        Path fileName = path.getFileName();
        String checkName = PackageObjectFactory.getShortFromFullModuleNames(event.getSourceName());
        String moduleIdName = event.getModuleId();
        boolean isAlreadyPresent = fileName != null ? (moduleIdName == null ? this.isFileAndCheckNamePresent(fileName, checkName) : this.isFileAndModuleIdPresent(fileName, moduleIdName)) : true;
        if (!isAlreadyPresent) {
            this.suppressXmlWriter(fileName, checkName, moduleIdName);
        }
    }

    private boolean isFileAndCheckNamePresent(Path fileName, String checkName) {
        boolean isPresent = false;
        Set<String> checks = this.filesAndChecksCollector.get(fileName);
        if (checks != null) {
            isPresent = checks.contains(checkName);
        }
        return isPresent;
    }

    private boolean isFileAndModuleIdPresent(Path fileName, String moduleIdName) {
        boolean isPresent = false;
        Set<String> moduleIds = this.filesAndModuleIdCollector.get(fileName);
        if (moduleIds != null) {
            isPresent = moduleIds.contains(moduleIdName);
        }
        return isPresent;
    }

    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    private void suppressXmlWriter(Path fileName, String checkName, String moduleIdName) {
        this.writer.println("  <suppress");
        this.writer.print("      files=\"");
        this.writer.print(fileName);
        this.writer.println(QUOTE_CHAR);
        if (moduleIdName == null) {
            this.writer.print("      checks=\"");
            this.writer.print(checkName);
        } else {
            this.writer.print("      id=\"");
            this.writer.print(moduleIdName);
        }
        this.writer.println("\"/>");
        this.addCheckOrModuleId(fileName, checkName, moduleIdName);
    }

    private void addCheckOrModuleId(Path fileName, String checkName, String moduleIdName) {
        if (moduleIdName == null) {
            ChecksAndFilesSuppressionFileGeneratorAuditListener.addToCollector(this.filesAndChecksCollector, fileName, checkName);
        } else {
            ChecksAndFilesSuppressionFileGeneratorAuditListener.addToCollector(this.filesAndModuleIdCollector, fileName, moduleIdName);
        }
    }

    private static void addToCollector(Map<Path, Set<String>> collector, Path fileName, String value) {
        Set values = collector.computeIfAbsent(fileName, key -> new HashSet());
        values.add(value);
    }

    private void printXmlHeader() {
        if (!this.isXmlHeaderPrinted) {
            this.writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.writer.println("<!DOCTYPE suppressions PUBLIC");
            this.writer.println("    \"-//Checkstyle//DTD SuppressionFilter Configuration 1.2//EN\"");
            this.writer.println("    \"https://checkstyle.org/dtds/suppressions_1_2.dtd\">");
            this.writer.println("<suppressions>");
            this.isXmlHeaderPrinted = true;
        }
    }

    @Override
    protected void finishLocalSetup() {
    }
}

