/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.PropertyType;
import com.puppycrawl.tools.checkstyle.XdocsPropertyType;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.meta.JavadocMetadataScraperUtil;
import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.sink.Sink;

public final class ModuleJavadocParsingUtil {
    public static final String NEWLINE = System.lineSeparator();
    public static final String INDENT_LEVEL_8 = SiteUtil.getNewlineAndIndentSpaces(8);
    public static final String INDENT_LEVEL_10 = SiteUtil.getNewlineAndIndentSpaces(10);
    public static final String INDENT_LEVEL_12 = SiteUtil.getNewlineAndIndentSpaces(12);
    public static final String INDENT_LEVEL_14 = SiteUtil.getNewlineAndIndentSpaces(14);
    public static final String INDENT_LEVEL_16 = SiteUtil.getNewlineAndIndentSpaces(16);
    public static final String INDENT_LEVEL_18 = SiteUtil.getNewlineAndIndentSpaces(18);
    public static final String INDENT_LEVEL_20 = SiteUtil.getNewlineAndIndentSpaces(20);
    public static final Set<String> HTML_TEXT_FORMAT_TAGS = Set.of("<code>", "<a", "</a>", "<b>", "</b>", "<strong>", "</strong>", "<i>", "</i>", "<em>", "</em>", "<small>", "</small>", "<ins>", "<sub>", "<sup>");
    public static final String NOTES = "Notes:";
    public static final Pattern NOTES_LINE = Pattern.compile("\\s*Notes:$");
    public static final Pattern NOTES_LINE_WITH_NEWLINE = Pattern.compile("\r?\n\\s?Notes:");

    private ModuleJavadocParsingUtil() {
    }

    public static Set<String> getPropertyNames(String moduleName) throws MacroExecutionException {
        Object instance = SiteUtil.getModuleInstance(moduleName);
        Class<?> clss = instance.getClass();
        return SiteUtil.getPropertiesForDocumentation(clss, instance);
    }

    private static boolean isStartOfNotesSection(DetailNode htmlElement) {
        DetailNode paragraphNode = JavadocUtil.findFirstToken(htmlElement, 10008);
        Optional<DetailNode> liNode = ModuleJavadocParsingUtil.getLiTagNode(htmlElement);
        return paragraphNode != null && JavadocMetadataScraperUtil.isChildNodeTextMatches(paragraphNode, NOTES_LINE) || liNode.isPresent() && JavadocMetadataScraperUtil.isChildNodeTextMatches(liNode.get(), NOTES_LINE);
    }

    public static Optional<DetailNode> getLiTagNode(DetailNode htmlElement) {
        return Optional.of(htmlElement).map(element -> JavadocUtil.findFirstToken(element, 10005)).map(element -> JavadocUtil.findFirstToken(element, 10001)).map(element -> JavadocUtil.findFirstToken(element, 10011));
    }

    public static void writeOutJavadocPortion(String javadocPortion, Sink sink) {
        String[] javadocPortionLinesSplit = javadocPortion.split(NEWLINE.replace("\r", ""));
        sink.rawText(javadocPortionLinesSplit[0]);
        String lastHtmlTag = javadocPortionLinesSplit[0];
        for (int index = 1; index < javadocPortionLinesSplit.length; ++index) {
            Object processedLine;
            String currentLine = javadocPortionLinesSplit[index].trim();
            if (currentLine.isEmpty()) {
                processedLine = NEWLINE;
            } else if (currentLine.startsWith("<") && !ModuleJavadocParsingUtil.startsWithTextFormattingHtmlTag(currentLine)) {
                processedLine = INDENT_LEVEL_8 + currentLine;
                lastHtmlTag = currentLine;
            } else if (lastHtmlTag.contains("<pre")) {
                String currentLineWithPreservedIndent = javadocPortionLinesSplit[index].substring(1);
                processedLine = NEWLINE + currentLineWithPreservedIndent;
            } else {
                processedLine = INDENT_LEVEL_10 + currentLine;
            }
            sink.rawText((String)processedLine);
        }
    }

    public static boolean startsWithTextFormattingHtmlTag(String line) {
        boolean result = false;
        for (String tag : HTML_TEXT_FORMAT_TAGS) {
            if (!line.startsWith(tag)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getModuleDescription(DetailNode moduleJavadoc) {
        int descriptionEndIndex = ModuleJavadocParsingUtil.getDescriptionEndIndex(moduleJavadoc);
        return JavadocMetadataScraperUtil.constructSubTreeText(moduleJavadoc, 0, descriptionEndIndex);
    }

    public static int getDescriptionEndIndex(DetailNode moduleJavadoc) {
        int descriptionEndIndex = -1;
        int notesStartingIndex = ModuleJavadocParsingUtil.getNotesSectionStartIndex(moduleJavadoc);
        descriptionEndIndex = notesStartingIndex > -1 ? (descriptionEndIndex += notesStartingIndex) : (descriptionEndIndex += ModuleJavadocParsingUtil.getModuleSinceVersionTagStartIndex(moduleJavadoc));
        return descriptionEndIndex;
    }

    public static int getNotesSectionStartIndex(DetailNode moduleJavadoc) {
        int notesStartIndex = -1;
        for (DetailNode node : moduleJavadoc.getChildren()) {
            if (node.getType() != 10001 || !ModuleJavadocParsingUtil.isStartOfNotesSection(node)) continue;
            notesStartIndex += node.getIndex();
            break;
        }
        return notesStartIndex;
    }

    public static int getModuleSinceVersionTagStartIndex(DetailNode moduleJavadoc) {
        return SiteUtil.getNodesOfSpecificType(moduleJavadoc.getChildren(), 10071).stream().filter(javadocTag -> JavadocUtil.findFirstToken(javadocTag, 16) != null).findFirst().map(DetailNode::getIndex).orElse(-1);
    }

    public static String getModuleNotes(DetailNode moduleJavadoc) {
        String result;
        int notesStartIndex = ModuleJavadocParsingUtil.getNotesSectionStartIndex(moduleJavadoc);
        if (notesStartIndex < 0) {
            result = "";
        } else {
            int notesEndIndex = ModuleJavadocParsingUtil.getNotesEndIndex(moduleJavadoc);
            String unprocessedNotes = JavadocMetadataScraperUtil.constructSubTreeText(moduleJavadoc, notesStartIndex, notesEndIndex);
            result = NOTES_LINE_WITH_NEWLINE.matcher(unprocessedNotes).replaceAll("");
        }
        return result;
    }

    public static int getNotesEndIndex(DetailNode moduleJavadoc) {
        int notesEndIndex = -1;
        return notesEndIndex += ModuleJavadocParsingUtil.getModuleSinceVersionTagStartIndex(moduleJavadoc);
    }

    public static boolean isPropertySpecialTokenProp(Field propertyField) {
        boolean result = false;
        if (propertyField != null) {
            XdocsPropertyType fieldXdocAnnotation = propertyField.getAnnotation(XdocsPropertyType.class);
            result = fieldXdocAnnotation != null && fieldXdocAnnotation.value() == PropertyType.TOKEN_ARRAY;
        }
        return result;
    }
}

