/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;
import com.puppycrawl.tools.checkstyle.utils.CodePointUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Locale;

@StatelessCheck
public class EmptyForInitializerPadCheck
extends AbstractCheck {
    public static final String MSG_PRECEDED = "ws.preceded";
    public static final String MSG_NOT_PRECEDED = "ws.notPreceded";
    private static final String SEMICOLON = ";";
    private PadOption option = PadOption.NOSPACE;

    public void setOption(String optionStr) {
        this.option = PadOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{35};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!ast.hasChildren()) {
            int lineIdx = ast.getLineNo() - 1;
            int[] line = this.getLineCodePoints(lineIdx);
            int before = ast.getColumnNo() - 1;
            if (ast.getColumnNo() > 0 && !CodePointUtil.hasWhitespaceBefore(before, line)) {
                if (this.option == PadOption.NOSPACE && CommonUtil.isCodePointWhitespace(line, before)) {
                    this.log(ast, MSG_PRECEDED, SEMICOLON);
                } else if (this.option == PadOption.SPACE && !CommonUtil.isCodePointWhitespace(line, before)) {
                    this.log(ast, MSG_NOT_PRECEDED, SEMICOLON);
                }
            }
        }
    }
}

