/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.checks.imports.AbstractImportRule;
import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;
import com.puppycrawl.tools.checkstyle.checks.imports.MismatchStrategy;
import java.util.Deque;
import java.util.LinkedList;

abstract class AbstractImportControl {
    private final Deque<AbstractImportRule> rules = new LinkedList<AbstractImportRule>();
    private final AbstractImportControl parent;
    private final MismatchStrategy strategyOnMismatch;

    protected AbstractImportControl(AbstractImportControl parent, MismatchStrategy strategyOnMismatch) {
        this.parent = parent;
        this.strategyOnMismatch = strategyOnMismatch;
    }

    public abstract AbstractImportControl locateFinest(String var1, String var2);

    protected abstract boolean matchesExactly(String var1, String var2);

    protected void addImportRule(AbstractImportRule rule) {
        this.rules.addLast(rule);
    }

    public AccessResult checkAccess(String inPkg, String inFileName, String forImport) {
        AccessResult returnValue = this.localCheckAccess(inPkg, inFileName, forImport);
        AccessResult result = returnValue != AccessResult.UNKNOWN ? returnValue : (this.parent == null ? (this.strategyOnMismatch == MismatchStrategy.ALLOWED ? AccessResult.ALLOWED : AccessResult.DISALLOWED) : (this.strategyOnMismatch == MismatchStrategy.ALLOWED ? AccessResult.ALLOWED : (this.strategyOnMismatch == MismatchStrategy.DISALLOWED ? AccessResult.DISALLOWED : this.parent.checkAccess(inPkg, inFileName, forImport))));
        return result;
    }

    private AccessResult localCheckAccess(String inPkg, String inFileName, String forImport) {
        AccessResult localCheckAccessResult = AccessResult.UNKNOWN;
        for (AbstractImportRule importRule : this.rules) {
            AccessResult result;
            if (importRule.isLocalOnly() && !this.matchesExactly(inPkg, inFileName) || (result = importRule.verifyImport(forImport)) == AccessResult.UNKNOWN) continue;
            localCheckAccessResult = result;
            break;
        }
        return localCheckAccessResult;
    }
}

